package zio.aws.rbin.model
import zio.ZIO
import zio.aws.rbin.model.primitives.{Description, RuleIdentifier}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateRuleRequest(
    identifier: RuleIdentifier,
    retentionPeriod: Optional[zio.aws.rbin.model.RetentionPeriod] =
      Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    resourceType: Optional[zio.aws.rbin.model.ResourceType] = Optional.Absent,
    resourceTags: Optional[Iterable[zio.aws.rbin.model.ResourceTag]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rbin.model.UpdateRuleRequest = {
    import UpdateRuleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rbin.model.UpdateRuleRequest
      .builder()
      .identifier(RuleIdentifier.unwrap(identifier): java.lang.String)
      .optionallyWith(retentionPeriod.map(value => value.buildAwsValue()))(
        _.retentionPeriod
      )
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(
        resourceTags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceTags)
      .build()
  }
  def asReadOnly: zio.aws.rbin.model.UpdateRuleRequest.ReadOnly =
    zio.aws.rbin.model.UpdateRuleRequest.wrap(buildAwsValue())
}
object UpdateRuleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rbin.model.UpdateRuleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rbin.model.UpdateRuleRequest =
      zio.aws.rbin.model.UpdateRuleRequest(
        identifier,
        retentionPeriod.map(value => value.asEditable),
        description.map(value => value),
        resourceType.map(value => value),
        resourceTags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def identifier: RuleIdentifier
    def retentionPeriod: Optional[zio.aws.rbin.model.RetentionPeriod.ReadOnly]
    def description: Optional[Description]
    def resourceType: Optional[zio.aws.rbin.model.ResourceType]
    def resourceTags: Optional[List[zio.aws.rbin.model.ResourceTag.ReadOnly]]
    def getIdentifier: ZIO[Any, Nothing, RuleIdentifier] =
      ZIO.succeed(identifier)
    def getRetentionPeriod
        : ZIO[Any, AwsError, zio.aws.rbin.model.RetentionPeriod.ReadOnly] =
      AwsError.unwrapOptionField("retentionPeriod", retentionPeriod)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getResourceType: ZIO[Any, AwsError, zio.aws.rbin.model.ResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getResourceTags
        : ZIO[Any, AwsError, List[zio.aws.rbin.model.ResourceTag.ReadOnly]] =
      AwsError.unwrapOptionField("resourceTags", resourceTags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rbin.model.UpdateRuleRequest
  ) extends zio.aws.rbin.model.UpdateRuleRequest.ReadOnly {
    override val identifier: RuleIdentifier =
      zio.aws.rbin.model.primitives.RuleIdentifier(impl.identifier())
    override val retentionPeriod
        : Optional[zio.aws.rbin.model.RetentionPeriod.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.retentionPeriod())
        .map(value => zio.aws.rbin.model.RetentionPeriod.wrap(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.rbin.model.primitives.Description(value))
    override val resourceType: Optional[zio.aws.rbin.model.ResourceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceType())
        .map(value => zio.aws.rbin.model.ResourceType.wrap(value))
    override val resourceTags
        : Optional[List[zio.aws.rbin.model.ResourceTag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceTags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rbin.model.ResourceTag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rbin.model.UpdateRuleRequest
  ): zio.aws.rbin.model.UpdateRuleRequest.ReadOnly = new Wrapper(impl)
}
