package zio.aws.rds.model
import scala.jdk.CollectionConverters._
sealed trait ActivityStreamMode {
  def unwrap: software.amazon.awssdk.services.rds.model.ActivityStreamMode
}
object ActivityStreamMode {
  def wrap(
      value: software.amazon.awssdk.services.rds.model.ActivityStreamMode
  ): zio.aws.rds.model.ActivityStreamMode = value match {
    case software.amazon.awssdk.services.rds.model.ActivityStreamMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.rds.model.ActivityStreamMode.SYNC =>
      val r = sync
      r
    case software.amazon.awssdk.services.rds.model.ActivityStreamMode.ASYNC =>
      val r = async
      r
  }
  case object unknownToSdkVersion extends zio.aws.rds.model.ActivityStreamMode {
    override def unwrap
        : software.amazon.awssdk.services.rds.model.ActivityStreamMode =
      software.amazon.awssdk.services.rds.model.ActivityStreamMode.UNKNOWN_TO_SDK_VERSION
  }
  case object sync extends zio.aws.rds.model.ActivityStreamMode {
    override def unwrap
        : software.amazon.awssdk.services.rds.model.ActivityStreamMode =
      software.amazon.awssdk.services.rds.model.ActivityStreamMode.SYNC
  }
  case object async extends zio.aws.rds.model.ActivityStreamMode {
    override def unwrap
        : software.amazon.awssdk.services.rds.model.ActivityStreamMode =
      software.amazon.awssdk.services.rds.model.ActivityStreamMode.ASYNC
  }
}
