package zio.aws.rds.model
import scala.jdk.CollectionConverters._
sealed trait AuthScheme {
  def unwrap: software.amazon.awssdk.services.rds.model.AuthScheme
}
object AuthScheme {
  def wrap(
      value: software.amazon.awssdk.services.rds.model.AuthScheme
  ): zio.aws.rds.model.AuthScheme = value match {
    case software.amazon.awssdk.services.rds.model.AuthScheme.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.rds.model.AuthScheme.SECRETS =>
      val r = SECRETS
      r
  }
  case object unknownToSdkVersion extends zio.aws.rds.model.AuthScheme {
    override def unwrap: software.amazon.awssdk.services.rds.model.AuthScheme =
      software.amazon.awssdk.services.rds.model.AuthScheme.UNKNOWN_TO_SDK_VERSION
  }
  case object SECRETS extends zio.aws.rds.model.AuthScheme {
    override def unwrap: software.amazon.awssdk.services.rds.model.AuthScheme =
      software.amazon.awssdk.services.rds.model.AuthScheme.SECRETS
  }
}
