package zio.aws.rds.model
import scala.jdk.CollectionConverters._
sealed trait AutomationMode {
  def unwrap: software.amazon.awssdk.services.rds.model.AutomationMode
}
object AutomationMode {
  def wrap(
      value: software.amazon.awssdk.services.rds.model.AutomationMode
  ): zio.aws.rds.model.AutomationMode = value match {
    case software.amazon.awssdk.services.rds.model.AutomationMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.rds.model.AutomationMode.FULL =>
      val r = full
      r
    case software.amazon.awssdk.services.rds.model.AutomationMode.ALL_PAUSED =>
      val r = `all-paused`
      r
  }
  case object unknownToSdkVersion extends zio.aws.rds.model.AutomationMode {
    override def unwrap
        : software.amazon.awssdk.services.rds.model.AutomationMode =
      software.amazon.awssdk.services.rds.model.AutomationMode.UNKNOWN_TO_SDK_VERSION
  }
  case object full extends zio.aws.rds.model.AutomationMode {
    override def unwrap
        : software.amazon.awssdk.services.rds.model.AutomationMode =
      software.amazon.awssdk.services.rds.model.AutomationMode.FULL
  }
  case object `all-paused` extends zio.aws.rds.model.AutomationMode {
    override def unwrap
        : software.amazon.awssdk.services.rds.model.AutomationMode =
      software.amazon.awssdk.services.rds.model.AutomationMode.ALL_PAUSED
  }
}
