package zio.aws.rds.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.rds.model.primitives.IntegerOptional
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ConnectionPoolConfiguration(
    maxConnectionsPercent: Optional[IntegerOptional] = Optional.Absent,
    maxIdleConnectionsPercent: Optional[IntegerOptional] = Optional.Absent,
    connectionBorrowTimeout: Optional[IntegerOptional] = Optional.Absent,
    sessionPinningFilters: Optional[Iterable[String]] = Optional.Absent,
    initQuery: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.ConnectionPoolConfiguration = {
    import ConnectionPoolConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.ConnectionPoolConfiguration
      .builder()
      .optionallyWith(maxConnectionsPercent.map(value => value: Integer))(
        _.maxConnectionsPercent
      )
      .optionallyWith(maxIdleConnectionsPercent.map(value => value: Integer))(
        _.maxIdleConnectionsPercent
      )
      .optionallyWith(connectionBorrowTimeout.map(value => value: Integer))(
        _.connectionBorrowTimeout
      )
      .optionallyWith(
        sessionPinningFilters.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.sessionPinningFilters)
      .optionallyWith(initQuery.map(value => value: java.lang.String))(
        _.initQuery
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.ConnectionPoolConfiguration.ReadOnly =
    zio.aws.rds.model.ConnectionPoolConfiguration.wrap(buildAwsValue())
}
object ConnectionPoolConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.ConnectionPoolConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.ConnectionPoolConfiguration =
      zio.aws.rds.model.ConnectionPoolConfiguration(
        maxConnectionsPercent.map(value => value),
        maxIdleConnectionsPercent.map(value => value),
        connectionBorrowTimeout.map(value => value),
        sessionPinningFilters.map(value => value),
        initQuery.map(value => value)
      )
    def maxConnectionsPercent: Optional[IntegerOptional]
    def maxIdleConnectionsPercent: Optional[IntegerOptional]
    def connectionBorrowTimeout: Optional[IntegerOptional]
    def sessionPinningFilters: Optional[List[String]]
    def initQuery: Optional[String]
    def getMaxConnectionsPercent: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxConnectionsPercent", maxConnectionsPercent)
    def getMaxIdleConnectionsPercent: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField(
        "maxIdleConnectionsPercent",
        maxIdleConnectionsPercent
      )
    def getConnectionBorrowTimeout: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField(
        "connectionBorrowTimeout",
        connectionBorrowTimeout
      )
    def getSessionPinningFilters: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("sessionPinningFilters", sessionPinningFilters)
    def getInitQuery: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("initQuery", initQuery)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.ConnectionPoolConfiguration
  ) extends zio.aws.rds.model.ConnectionPoolConfiguration.ReadOnly {
    override val maxConnectionsPercent: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxConnectionsPercent())
        .map(value => value: IntegerOptional)
    override val maxIdleConnectionsPercent: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxIdleConnectionsPercent())
        .map(value => value: IntegerOptional)
    override val connectionBorrowTimeout: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectionBorrowTimeout())
        .map(value => value: IntegerOptional)
    override val sessionPinningFilters: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sessionPinningFilters())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val initQuery: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.initQuery())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.ConnectionPoolConfiguration
  ): zio.aws.rds.model.ConnectionPoolConfiguration.ReadOnly = new Wrapper(impl)
}
