package zio.aws.rds.model
import zio.aws.rds.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ConnectionPoolConfigurationInfo(
    maxConnectionsPercent: Optional[Integer] = Optional.Absent,
    maxIdleConnectionsPercent: Optional[Integer] = Optional.Absent,
    connectionBorrowTimeout: Optional[Integer] = Optional.Absent,
    sessionPinningFilters: Optional[Iterable[String]] = Optional.Absent,
    initQuery: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.ConnectionPoolConfigurationInfo = {
    import ConnectionPoolConfigurationInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.ConnectionPoolConfigurationInfo
      .builder()
      .optionallyWith(
        maxConnectionsPercent.map(value => value: java.lang.Integer)
      )(_.maxConnectionsPercent)
      .optionallyWith(
        maxIdleConnectionsPercent.map(value => value: java.lang.Integer)
      )(_.maxIdleConnectionsPercent)
      .optionallyWith(
        connectionBorrowTimeout.map(value => value: java.lang.Integer)
      )(_.connectionBorrowTimeout)
      .optionallyWith(
        sessionPinningFilters.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.sessionPinningFilters)
      .optionallyWith(initQuery.map(value => value: java.lang.String))(
        _.initQuery
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.ConnectionPoolConfigurationInfo.ReadOnly =
    zio.aws.rds.model.ConnectionPoolConfigurationInfo.wrap(buildAwsValue())
}
object ConnectionPoolConfigurationInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.ConnectionPoolConfigurationInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.ConnectionPoolConfigurationInfo =
      zio.aws.rds.model.ConnectionPoolConfigurationInfo(
        maxConnectionsPercent.map(value => value),
        maxIdleConnectionsPercent.map(value => value),
        connectionBorrowTimeout.map(value => value),
        sessionPinningFilters.map(value => value),
        initQuery.map(value => value)
      )
    def maxConnectionsPercent: Optional[Integer]
    def maxIdleConnectionsPercent: Optional[Integer]
    def connectionBorrowTimeout: Optional[Integer]
    def sessionPinningFilters: Optional[List[String]]
    def initQuery: Optional[String]
    def getMaxConnectionsPercent: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxConnectionsPercent", maxConnectionsPercent)
    def getMaxIdleConnectionsPercent: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("maxIdleConnectionsPercent", maxIdleConnectionsPercent)
    def getConnectionBorrowTimeout: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("connectionBorrowTimeout", connectionBorrowTimeout)
    def getSessionPinningFilters: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("sessionPinningFilters", sessionPinningFilters)
    def getInitQuery: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("initQuery", initQuery)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.ConnectionPoolConfigurationInfo
  ) extends zio.aws.rds.model.ConnectionPoolConfigurationInfo.ReadOnly {
    override val maxConnectionsPercent: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxConnectionsPercent())
        .map(value => value: Integer)
    override val maxIdleConnectionsPercent: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxIdleConnectionsPercent())
        .map(value => value: Integer)
    override val connectionBorrowTimeout: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectionBorrowTimeout())
        .map(value => value: Integer)
    override val sessionPinningFilters: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sessionPinningFilters())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val initQuery: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.initQuery())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.ConnectionPoolConfigurationInfo
  ): zio.aws.rds.model.ConnectionPoolConfigurationInfo.ReadOnly = new Wrapper(
    impl
  )
}
