package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CopyDbParameterGroupResponse(
    dbParameterGroup: Optional[zio.aws.rds.model.DBParameterGroup] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.CopyDbParameterGroupResponse = {
    import CopyDbParameterGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.CopyDbParameterGroupResponse
      .builder()
      .optionallyWith(dbParameterGroup.map(value => value.buildAwsValue()))(
        _.dbParameterGroup
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.CopyDbParameterGroupResponse.ReadOnly =
    zio.aws.rds.model.CopyDbParameterGroupResponse.wrap(buildAwsValue())
}
object CopyDbParameterGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.CopyDbParameterGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.CopyDbParameterGroupResponse =
      zio.aws.rds.model.CopyDbParameterGroupResponse(
        dbParameterGroup.map(value => value.asEditable)
      )
    def dbParameterGroup: Optional[zio.aws.rds.model.DBParameterGroup.ReadOnly]
    def getDbParameterGroup
        : ZIO[Any, AwsError, zio.aws.rds.model.DBParameterGroup.ReadOnly] =
      AwsError.unwrapOptionField("dbParameterGroup", dbParameterGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.CopyDbParameterGroupResponse
  ) extends zio.aws.rds.model.CopyDbParameterGroupResponse.ReadOnly {
    override val dbParameterGroup
        : Optional[zio.aws.rds.model.DBParameterGroup.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbParameterGroup())
        .map(value => zio.aws.rds.model.DBParameterGroup.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.CopyDbParameterGroupResponse
  ): zio.aws.rds.model.CopyDbParameterGroupResponse.ReadOnly = new Wrapper(impl)
}
