package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateDbParameterGroupRequest(
    dbParameterGroupName: String,
    dbParameterGroupFamily: String,
    description: String,
    tags: Optional[Iterable[zio.aws.rds.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.CreateDbParameterGroupRequest = {
    import CreateDbParameterGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.CreateDbParameterGroupRequest
      .builder()
      .dbParameterGroupName(dbParameterGroupName: java.lang.String)
      .dbParameterGroupFamily(dbParameterGroupFamily: java.lang.String)
      .description(description: java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.CreateDbParameterGroupRequest.ReadOnly =
    zio.aws.rds.model.CreateDbParameterGroupRequest.wrap(buildAwsValue())
}
object CreateDbParameterGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.CreateDbParameterGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.CreateDbParameterGroupRequest =
      zio.aws.rds.model.CreateDbParameterGroupRequest(
        dbParameterGroupName,
        dbParameterGroupFamily,
        description,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def dbParameterGroupName: String
    def dbParameterGroupFamily: String
    def description: String
    def tags: Optional[List[zio.aws.rds.model.Tag.ReadOnly]]
    def getDbParameterGroupName: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbParameterGroupName)
    def getDbParameterGroupFamily: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbParameterGroupFamily)
    def getDescription: ZIO[Any, Nothing, String] = ZIO.succeed(description)
    def getTags: ZIO[Any, AwsError, List[zio.aws.rds.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.CreateDbParameterGroupRequest
  ) extends zio.aws.rds.model.CreateDbParameterGroupRequest.ReadOnly {
    override val dbParameterGroupName: String =
      impl.dbParameterGroupName(): String
    override val dbParameterGroupFamily: String =
      impl.dbParameterGroupFamily(): String
    override val description: String = impl.description(): String
    override val tags: Optional[List[zio.aws.rds.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.CreateDbParameterGroupRequest
  ): zio.aws.rds.model.CreateDbParameterGroupRequest.ReadOnly = new Wrapper(
    impl
  )
}
