package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateDbSnapshotRequest(
    dbSnapshotIdentifier: String,
    dbInstanceIdentifier: String,
    tags: Optional[Iterable[zio.aws.rds.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.CreateDbSnapshotRequest = {
    import CreateDbSnapshotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.CreateDbSnapshotRequest
      .builder()
      .dbSnapshotIdentifier(dbSnapshotIdentifier: java.lang.String)
      .dbInstanceIdentifier(dbInstanceIdentifier: java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.CreateDbSnapshotRequest.ReadOnly =
    zio.aws.rds.model.CreateDbSnapshotRequest.wrap(buildAwsValue())
}
object CreateDbSnapshotRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.CreateDbSnapshotRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.CreateDbSnapshotRequest =
      zio.aws.rds.model.CreateDbSnapshotRequest(
        dbSnapshotIdentifier,
        dbInstanceIdentifier,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def dbSnapshotIdentifier: String
    def dbInstanceIdentifier: String
    def tags: Optional[List[zio.aws.rds.model.Tag.ReadOnly]]
    def getDbSnapshotIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbSnapshotIdentifier)
    def getDbInstanceIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbInstanceIdentifier)
    def getTags: ZIO[Any, AwsError, List[zio.aws.rds.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.CreateDbSnapshotRequest
  ) extends zio.aws.rds.model.CreateDbSnapshotRequest.ReadOnly {
    override val dbSnapshotIdentifier: String =
      impl.dbSnapshotIdentifier(): String
    override val dbInstanceIdentifier: String =
      impl.dbInstanceIdentifier(): String
    override val tags: Optional[List[zio.aws.rds.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.CreateDbSnapshotRequest
  ): zio.aws.rds.model.CreateDbSnapshotRequest.ReadOnly = new Wrapper(impl)
}
