package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateOptionGroupRequest(
    optionGroupName: String,
    engineName: String,
    majorEngineVersion: String,
    optionGroupDescription: String,
    tags: Optional[Iterable[zio.aws.rds.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.CreateOptionGroupRequest = {
    import CreateOptionGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.CreateOptionGroupRequest
      .builder()
      .optionGroupName(optionGroupName: java.lang.String)
      .engineName(engineName: java.lang.String)
      .majorEngineVersion(majorEngineVersion: java.lang.String)
      .optionGroupDescription(optionGroupDescription: java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.CreateOptionGroupRequest.ReadOnly =
    zio.aws.rds.model.CreateOptionGroupRequest.wrap(buildAwsValue())
}
object CreateOptionGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.CreateOptionGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.CreateOptionGroupRequest =
      zio.aws.rds.model.CreateOptionGroupRequest(
        optionGroupName,
        engineName,
        majorEngineVersion,
        optionGroupDescription,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def optionGroupName: String
    def engineName: String
    def majorEngineVersion: String
    def optionGroupDescription: String
    def tags: Optional[List[zio.aws.rds.model.Tag.ReadOnly]]
    def getOptionGroupName: ZIO[Any, Nothing, String] =
      ZIO.succeed(optionGroupName)
    def getEngineName: ZIO[Any, Nothing, String] = ZIO.succeed(engineName)
    def getMajorEngineVersion: ZIO[Any, Nothing, String] =
      ZIO.succeed(majorEngineVersion)
    def getOptionGroupDescription: ZIO[Any, Nothing, String] =
      ZIO.succeed(optionGroupDescription)
    def getTags: ZIO[Any, AwsError, List[zio.aws.rds.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.CreateOptionGroupRequest
  ) extends zio.aws.rds.model.CreateOptionGroupRequest.ReadOnly {
    override val optionGroupName: String = impl.optionGroupName(): String
    override val engineName: String = impl.engineName(): String
    override val majorEngineVersion: String = impl.majorEngineVersion(): String
    override val optionGroupDescription: String =
      impl.optionGroupDescription(): String
    override val tags: Optional[List[zio.aws.rds.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.CreateOptionGroupRequest
  ): zio.aws.rds.model.CreateOptionGroupRequest.ReadOnly = new Wrapper(impl)
}
