package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DBClusterParameterGroup(
    dbClusterParameterGroupName: Optional[String] = Optional.Absent,
    dbParameterGroupFamily: Optional[String] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    dbClusterParameterGroupArn: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DBClusterParameterGroup = {
    import DBClusterParameterGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DBClusterParameterGroup
      .builder()
      .optionallyWith(
        dbClusterParameterGroupName.map(value => value: java.lang.String)
      )(_.dbClusterParameterGroupName)
      .optionallyWith(
        dbParameterGroupFamily.map(value => value: java.lang.String)
      )(_.dbParameterGroupFamily)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        dbClusterParameterGroupArn.map(value => value: java.lang.String)
      )(_.dbClusterParameterGroupArn)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DBClusterParameterGroup.ReadOnly =
    zio.aws.rds.model.DBClusterParameterGroup.wrap(buildAwsValue())
}
object DBClusterParameterGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DBClusterParameterGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DBClusterParameterGroup =
      zio.aws.rds.model.DBClusterParameterGroup(
        dbClusterParameterGroupName.map(value => value),
        dbParameterGroupFamily.map(value => value),
        description.map(value => value),
        dbClusterParameterGroupArn.map(value => value)
      )
    def dbClusterParameterGroupName: Optional[String]
    def dbParameterGroupFamily: Optional[String]
    def description: Optional[String]
    def dbClusterParameterGroupArn: Optional[String]
    def getDbClusterParameterGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "dbClusterParameterGroupName",
        dbClusterParameterGroupName
      )
    def getDbParameterGroupFamily: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("dbParameterGroupFamily", dbParameterGroupFamily)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getDbClusterParameterGroupArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "dbClusterParameterGroupArn",
        dbClusterParameterGroupArn
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DBClusterParameterGroup
  ) extends zio.aws.rds.model.DBClusterParameterGroup.ReadOnly {
    override val dbClusterParameterGroupName: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbClusterParameterGroupName())
        .map(value => value: String)
    override val dbParameterGroupFamily: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbParameterGroupFamily())
        .map(value => value: String)
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val dbClusterParameterGroupArn: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbClusterParameterGroupArn())
        .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DBClusterParameterGroup
  ): zio.aws.rds.model.DBClusterParameterGroup.ReadOnly = new Wrapper(impl)
}
