package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteDbParameterGroupRequest(dbParameterGroupName: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DeleteDbParameterGroupRequest = {
    import DeleteDbParameterGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DeleteDbParameterGroupRequest
      .builder()
      .dbParameterGroupName(dbParameterGroupName: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DeleteDbParameterGroupRequest.ReadOnly =
    zio.aws.rds.model.DeleteDbParameterGroupRequest.wrap(buildAwsValue())
}
object DeleteDbParameterGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DeleteDbParameterGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DeleteDbParameterGroupRequest =
      zio.aws.rds.model.DeleteDbParameterGroupRequest(dbParameterGroupName)
    def dbParameterGroupName: String
    def getDbParameterGroupName: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbParameterGroupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DeleteDbParameterGroupRequest
  ) extends zio.aws.rds.model.DeleteDbParameterGroupRequest.ReadOnly {
    override val dbParameterGroupName: String =
      impl.dbParameterGroupName(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DeleteDbParameterGroupRequest
  ): zio.aws.rds.model.DeleteDbParameterGroupRequest.ReadOnly = new Wrapper(
    impl
  )
}
