package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteEventSubscriptionResponse(
    eventSubscription: Optional[zio.aws.rds.model.EventSubscription] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DeleteEventSubscriptionResponse = {
    import DeleteEventSubscriptionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DeleteEventSubscriptionResponse
      .builder()
      .optionallyWith(eventSubscription.map(value => value.buildAwsValue()))(
        _.eventSubscription
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DeleteEventSubscriptionResponse.ReadOnly =
    zio.aws.rds.model.DeleteEventSubscriptionResponse.wrap(buildAwsValue())
}
object DeleteEventSubscriptionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DeleteEventSubscriptionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DeleteEventSubscriptionResponse =
      zio.aws.rds.model.DeleteEventSubscriptionResponse(
        eventSubscription.map(value => value.asEditable)
      )
    def eventSubscription
        : Optional[zio.aws.rds.model.EventSubscription.ReadOnly]
    def getEventSubscription
        : ZIO[Any, AwsError, zio.aws.rds.model.EventSubscription.ReadOnly] =
      AwsError.unwrapOptionField("eventSubscription", eventSubscription)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DeleteEventSubscriptionResponse
  ) extends zio.aws.rds.model.DeleteEventSubscriptionResponse.ReadOnly {
    override val eventSubscription
        : Optional[zio.aws.rds.model.EventSubscription.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eventSubscription())
        .map(value => zio.aws.rds.model.EventSubscription.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DeleteEventSubscriptionResponse
  ): zio.aws.rds.model.DeleteEventSubscriptionResponse.ReadOnly = new Wrapper(
    impl
  )
}
