package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeDbSnapshotAttributesResponse(
    dbSnapshotAttributesResult: Optional[
      zio.aws.rds.model.DBSnapshotAttributesResult
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DescribeDbSnapshotAttributesResponse = {
    import DescribeDbSnapshotAttributesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DescribeDbSnapshotAttributesResponse
      .builder()
      .optionallyWith(
        dbSnapshotAttributesResult.map(value => value.buildAwsValue())
      )(_.dbSnapshotAttributesResult)
      .build()
  }
  def asReadOnly
      : zio.aws.rds.model.DescribeDbSnapshotAttributesResponse.ReadOnly =
    zio.aws.rds.model.DescribeDbSnapshotAttributesResponse.wrap(buildAwsValue())
}
object DescribeDbSnapshotAttributesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DescribeDbSnapshotAttributesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DescribeDbSnapshotAttributesResponse =
      zio.aws.rds.model.DescribeDbSnapshotAttributesResponse(
        dbSnapshotAttributesResult.map(value => value.asEditable)
      )
    def dbSnapshotAttributesResult
        : Optional[zio.aws.rds.model.DBSnapshotAttributesResult.ReadOnly]
    def getDbSnapshotAttributesResult: ZIO[
      Any,
      AwsError,
      zio.aws.rds.model.DBSnapshotAttributesResult.ReadOnly
    ] = AwsError.unwrapOptionField(
      "dbSnapshotAttributesResult",
      dbSnapshotAttributesResult
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DescribeDbSnapshotAttributesResponse
  ) extends zio.aws.rds.model.DescribeDbSnapshotAttributesResponse.ReadOnly {
    override val dbSnapshotAttributesResult
        : Optional[zio.aws.rds.model.DBSnapshotAttributesResult.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbSnapshotAttributesResult())
        .map(value => zio.aws.rds.model.DBSnapshotAttributesResult.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DescribeDbSnapshotAttributesResponse
  ): zio.aws.rds.model.DescribeDbSnapshotAttributesResponse.ReadOnly =
    new Wrapper(impl)
}
