package zio.aws.rds.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.rds.model.primitives.IntegerOptional
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeOptionGroupsRequest(
    optionGroupName: Optional[String] = Optional.Absent,
    filters: Optional[Iterable[zio.aws.rds.model.Filter]] = Optional.Absent,
    marker: Optional[String] = Optional.Absent,
    maxRecords: Optional[IntegerOptional] = Optional.Absent,
    engineName: Optional[String] = Optional.Absent,
    majorEngineVersion: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DescribeOptionGroupsRequest = {
    import DescribeOptionGroupsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DescribeOptionGroupsRequest
      .builder()
      .optionallyWith(optionGroupName.map(value => value: java.lang.String))(
        _.optionGroupName
      )
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(maxRecords.map(value => value: Integer))(_.maxRecords)
      .optionallyWith(engineName.map(value => value: java.lang.String))(
        _.engineName
      )
      .optionallyWith(majorEngineVersion.map(value => value: java.lang.String))(
        _.majorEngineVersion
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DescribeOptionGroupsRequest.ReadOnly =
    zio.aws.rds.model.DescribeOptionGroupsRequest.wrap(buildAwsValue())
}
object DescribeOptionGroupsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DescribeOptionGroupsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DescribeOptionGroupsRequest =
      zio.aws.rds.model.DescribeOptionGroupsRequest(
        optionGroupName.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        marker.map(value => value),
        maxRecords.map(value => value),
        engineName.map(value => value),
        majorEngineVersion.map(value => value)
      )
    def optionGroupName: Optional[String]
    def filters: Optional[List[zio.aws.rds.model.Filter.ReadOnly]]
    def marker: Optional[String]
    def maxRecords: Optional[IntegerOptional]
    def engineName: Optional[String]
    def majorEngineVersion: Optional[String]
    def getOptionGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("optionGroupName", optionGroupName)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.rds.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getEngineName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineName", engineName)
    def getMajorEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("majorEngineVersion", majorEngineVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DescribeOptionGroupsRequest
  ) extends zio.aws.rds.model.DescribeOptionGroupsRequest.ReadOnly {
    override val optionGroupName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.optionGroupName())
      .map(value => value: String)
    override val filters: Optional[List[zio.aws.rds.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.Filter.wrap(item)
          }.toList
        )
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
    override val maxRecords: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.maxRecords())
      .map(value => value: IntegerOptional)
    override val engineName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engineName())
      .map(value => value: String)
    override val majorEngineVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.majorEngineVersion())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DescribeOptionGroupsRequest
  ): zio.aws.rds.model.DescribeOptionGroupsRequest.ReadOnly = new Wrapper(impl)
}
