package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeValidDbInstanceModificationsRequest(
    dbInstanceIdentifier: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DescribeValidDbInstanceModificationsRequest = {
    import DescribeValidDbInstanceModificationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DescribeValidDbInstanceModificationsRequest
      .builder()
      .dbInstanceIdentifier(dbInstanceIdentifier: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.rds.model.DescribeValidDbInstanceModificationsRequest.ReadOnly =
    zio.aws.rds.model.DescribeValidDbInstanceModificationsRequest
      .wrap(buildAwsValue())
}
object DescribeValidDbInstanceModificationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DescribeValidDbInstanceModificationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.rds.model.DescribeValidDbInstanceModificationsRequest =
      zio.aws.rds.model
        .DescribeValidDbInstanceModificationsRequest(dbInstanceIdentifier)
    def dbInstanceIdentifier: String
    def getDbInstanceIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbInstanceIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DescribeValidDbInstanceModificationsRequest
  ) extends zio.aws.rds.model.DescribeValidDbInstanceModificationsRequest.ReadOnly {
    override val dbInstanceIdentifier: String =
      impl.dbInstanceIdentifier(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DescribeValidDbInstanceModificationsRequest
  ): zio.aws.rds.model.DescribeValidDbInstanceModificationsRequest.ReadOnly =
    new Wrapper(impl)
}
