package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifyDbSnapshotRequest(
    dbSnapshotIdentifier: String,
    engineVersion: Optional[String] = Optional.Absent,
    optionGroupName: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.ModifyDbSnapshotRequest = {
    import ModifyDbSnapshotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.ModifyDbSnapshotRequest
      .builder()
      .dbSnapshotIdentifier(dbSnapshotIdentifier: java.lang.String)
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(optionGroupName.map(value => value: java.lang.String))(
        _.optionGroupName
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.ModifyDbSnapshotRequest.ReadOnly =
    zio.aws.rds.model.ModifyDbSnapshotRequest.wrap(buildAwsValue())
}
object ModifyDbSnapshotRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.ModifyDbSnapshotRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.ModifyDbSnapshotRequest =
      zio.aws.rds.model.ModifyDbSnapshotRequest(
        dbSnapshotIdentifier,
        engineVersion.map(value => value),
        optionGroupName.map(value => value)
      )
    def dbSnapshotIdentifier: String
    def engineVersion: Optional[String]
    def optionGroupName: Optional[String]
    def getDbSnapshotIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbSnapshotIdentifier)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getOptionGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("optionGroupName", optionGroupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.ModifyDbSnapshotRequest
  ) extends zio.aws.rds.model.ModifyDbSnapshotRequest.ReadOnly {
    override val dbSnapshotIdentifier: String =
      impl.dbSnapshotIdentifier(): String
    override val engineVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engineVersion())
      .map(value => value: String)
    override val optionGroupName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.optionGroupName())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.ModifyDbSnapshotRequest
  ): zio.aws.rds.model.ModifyDbSnapshotRequest.ReadOnly = new Wrapper(impl)
}
