package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PurchaseReservedDbInstancesOfferingResponse(
    reservedDBInstance: Optional[zio.aws.rds.model.ReservedDBInstance] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.PurchaseReservedDbInstancesOfferingResponse = {
    import PurchaseReservedDbInstancesOfferingResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.PurchaseReservedDbInstancesOfferingResponse
      .builder()
      .optionallyWith(reservedDBInstance.map(value => value.buildAwsValue()))(
        _.reservedDBInstance
      )
      .build()
  }
  def asReadOnly
      : zio.aws.rds.model.PurchaseReservedDbInstancesOfferingResponse.ReadOnly =
    zio.aws.rds.model.PurchaseReservedDbInstancesOfferingResponse
      .wrap(buildAwsValue())
}
object PurchaseReservedDbInstancesOfferingResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.PurchaseReservedDbInstancesOfferingResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.rds.model.PurchaseReservedDbInstancesOfferingResponse =
      zio.aws.rds.model.PurchaseReservedDbInstancesOfferingResponse(
        reservedDBInstance.map(value => value.asEditable)
      )
    def reservedDBInstance
        : Optional[zio.aws.rds.model.ReservedDBInstance.ReadOnly]
    def getReservedDBInstance
        : ZIO[Any, AwsError, zio.aws.rds.model.ReservedDBInstance.ReadOnly] =
      AwsError.unwrapOptionField("reservedDBInstance", reservedDBInstance)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.PurchaseReservedDbInstancesOfferingResponse
  ) extends zio.aws.rds.model.PurchaseReservedDbInstancesOfferingResponse.ReadOnly {
    override val reservedDBInstance
        : Optional[zio.aws.rds.model.ReservedDBInstance.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reservedDBInstance())
        .map(value => zio.aws.rds.model.ReservedDBInstance.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.PurchaseReservedDbInstancesOfferingResponse
  ): zio.aws.rds.model.PurchaseReservedDbInstancesOfferingResponse.ReadOnly =
    new Wrapper(impl)
}
