package zio.aws.rds.model
import zio.aws.rds.model.primitives.BooleanOptional
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StartActivityStreamResponse(
    kmsKeyId: Optional[String] = Optional.Absent,
    kinesisStreamName: Optional[String] = Optional.Absent,
    status: Optional[zio.aws.rds.model.ActivityStreamStatus] = Optional.Absent,
    mode: Optional[zio.aws.rds.model.ActivityStreamMode] = Optional.Absent,
    applyImmediately: Optional[Boolean] = Optional.Absent,
    engineNativeAuditFieldsIncluded: Optional[BooleanOptional] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.StartActivityStreamResponse = {
    import StartActivityStreamResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.StartActivityStreamResponse
      .builder()
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(kinesisStreamName.map(value => value: java.lang.String))(
        _.kinesisStreamName
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(mode.map(value => value.unwrap))(_.mode)
      .optionallyWith(applyImmediately.map(value => value: java.lang.Boolean))(
        _.applyImmediately
      )
      .optionallyWith(
        engineNativeAuditFieldsIncluded.map(value => value: java.lang.Boolean)
      )(_.engineNativeAuditFieldsIncluded)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.StartActivityStreamResponse.ReadOnly =
    zio.aws.rds.model.StartActivityStreamResponse.wrap(buildAwsValue())
}
object StartActivityStreamResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.StartActivityStreamResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.StartActivityStreamResponse =
      zio.aws.rds.model.StartActivityStreamResponse(
        kmsKeyId.map(value => value),
        kinesisStreamName.map(value => value),
        status.map(value => value),
        mode.map(value => value),
        applyImmediately.map(value => value),
        engineNativeAuditFieldsIncluded.map(value => value)
      )
    def kmsKeyId: Optional[String]
    def kinesisStreamName: Optional[String]
    def status: Optional[zio.aws.rds.model.ActivityStreamStatus]
    def mode: Optional[zio.aws.rds.model.ActivityStreamMode]
    def applyImmediately: Optional[Boolean]
    def engineNativeAuditFieldsIncluded: Optional[BooleanOptional]
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getKinesisStreamName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kinesisStreamName", kinesisStreamName)
    def getStatus: ZIO[Any, AwsError, zio.aws.rds.model.ActivityStreamStatus] =
      AwsError.unwrapOptionField("status", status)
    def getMode: ZIO[Any, AwsError, zio.aws.rds.model.ActivityStreamMode] =
      AwsError.unwrapOptionField("mode", mode)
    def getApplyImmediately: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("applyImmediately", applyImmediately)
    def getEngineNativeAuditFieldsIncluded
        : ZIO[Any, AwsError, BooleanOptional] = AwsError.unwrapOptionField(
      "engineNativeAuditFieldsIncluded",
      engineNativeAuditFieldsIncluded
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.StartActivityStreamResponse
  ) extends zio.aws.rds.model.StartActivityStreamResponse.ReadOnly {
    override val kmsKeyId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => value: String)
    override val kinesisStreamName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.kinesisStreamName())
      .map(value => value: String)
    override val status: Optional[zio.aws.rds.model.ActivityStreamStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.rds.model.ActivityStreamStatus.wrap(value))
    override val mode: Optional[zio.aws.rds.model.ActivityStreamMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mode())
        .map(value => zio.aws.rds.model.ActivityStreamMode.wrap(value))
    override val applyImmediately: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.applyImmediately())
      .map(value => value: Boolean)
    override val engineNativeAuditFieldsIncluded: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.engineNativeAuditFieldsIncluded())
        .map(value => value: BooleanOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.StartActivityStreamResponse
  ): zio.aws.rds.model.StartActivityStreamResponse.ReadOnly = new Wrapper(impl)
}
