package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StopActivityStreamResponse(
    kmsKeyId: Optional[String] = Optional.Absent,
    kinesisStreamName: Optional[String] = Optional.Absent,
    status: Optional[zio.aws.rds.model.ActivityStreamStatus] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.StopActivityStreamResponse = {
    import StopActivityStreamResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.StopActivityStreamResponse
      .builder()
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(kinesisStreamName.map(value => value: java.lang.String))(
        _.kinesisStreamName
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.StopActivityStreamResponse.ReadOnly =
    zio.aws.rds.model.StopActivityStreamResponse.wrap(buildAwsValue())
}
object StopActivityStreamResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.StopActivityStreamResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.StopActivityStreamResponse =
      zio.aws.rds.model.StopActivityStreamResponse(
        kmsKeyId.map(value => value),
        kinesisStreamName.map(value => value),
        status.map(value => value)
      )
    def kmsKeyId: Optional[String]
    def kinesisStreamName: Optional[String]
    def status: Optional[zio.aws.rds.model.ActivityStreamStatus]
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getKinesisStreamName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kinesisStreamName", kinesisStreamName)
    def getStatus: ZIO[Any, AwsError, zio.aws.rds.model.ActivityStreamStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.StopActivityStreamResponse
  ) extends zio.aws.rds.model.StopActivityStreamResponse.ReadOnly {
    override val kmsKeyId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => value: String)
    override val kinesisStreamName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.kinesisStreamName())
      .map(value => value: String)
    override val status: Optional[zio.aws.rds.model.ActivityStreamStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.rds.model.ActivityStreamStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.StopActivityStreamResponse
  ): zio.aws.rds.model.StopActivityStreamResponse.ReadOnly = new Wrapper(impl)
}
