package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ValidDBInstanceModificationsMessage(
    storage: Optional[Iterable[zio.aws.rds.model.ValidStorageOptions]] =
      Optional.Absent,
    validProcessorFeatures: Optional[
      Iterable[zio.aws.rds.model.AvailableProcessorFeature]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.ValidDBInstanceModificationsMessage = {
    import ValidDBInstanceModificationsMessage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.ValidDBInstanceModificationsMessage
      .builder()
      .optionallyWith(
        storage.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.storage)
      .optionallyWith(
        validProcessorFeatures.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.validProcessorFeatures)
      .build()
  }
  def asReadOnly
      : zio.aws.rds.model.ValidDBInstanceModificationsMessage.ReadOnly =
    zio.aws.rds.model.ValidDBInstanceModificationsMessage.wrap(buildAwsValue())
}
object ValidDBInstanceModificationsMessage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.ValidDBInstanceModificationsMessage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.ValidDBInstanceModificationsMessage =
      zio.aws.rds.model.ValidDBInstanceModificationsMessage(
        storage.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        validProcessorFeatures.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def storage: Optional[List[zio.aws.rds.model.ValidStorageOptions.ReadOnly]]
    def validProcessorFeatures
        : Optional[List[zio.aws.rds.model.AvailableProcessorFeature.ReadOnly]]
    def getStorage: ZIO[Any, AwsError, List[
      zio.aws.rds.model.ValidStorageOptions.ReadOnly
    ]] = AwsError.unwrapOptionField("storage", storage)
    def getValidProcessorFeatures: ZIO[Any, AwsError, List[
      zio.aws.rds.model.AvailableProcessorFeature.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "validProcessorFeatures",
      validProcessorFeatures
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.ValidDBInstanceModificationsMessage
  ) extends zio.aws.rds.model.ValidDBInstanceModificationsMessage.ReadOnly {
    override val storage
        : Optional[List[zio.aws.rds.model.ValidStorageOptions.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storage())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.ValidStorageOptions.wrap(item)
          }.toList
        )
    override val validProcessorFeatures
        : Optional[List[zio.aws.rds.model.AvailableProcessorFeature.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.validProcessorFeatures())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.AvailableProcessorFeature.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.ValidDBInstanceModificationsMessage
  ): zio.aws.rds.model.ValidDBInstanceModificationsMessage.ReadOnly =
    new Wrapper(impl)
}
