package zio.aws.rds.model
import scala.jdk.CollectionConverters._
sealed trait ActivityStreamStatus {
  def unwrap: software.amazon.awssdk.services.rds.model.ActivityStreamStatus
}
object ActivityStreamStatus {
  def wrap(
      value: software.amazon.awssdk.services.rds.model.ActivityStreamStatus
  ): zio.aws.rds.model.ActivityStreamStatus = value match {
    case software.amazon.awssdk.services.rds.model.ActivityStreamStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.rds.model.ActivityStreamStatus.STOPPED =>
      val r = stopped
      r
    case software.amazon.awssdk.services.rds.model.ActivityStreamStatus.STARTING =>
      val r = starting
      r
    case software.amazon.awssdk.services.rds.model.ActivityStreamStatus.STARTED =>
      val r = started
      r
    case software.amazon.awssdk.services.rds.model.ActivityStreamStatus.STOPPING =>
      val r = stopping
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.rds.model.ActivityStreamStatus {
    override def unwrap
        : software.amazon.awssdk.services.rds.model.ActivityStreamStatus =
      software.amazon.awssdk.services.rds.model.ActivityStreamStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object stopped extends zio.aws.rds.model.ActivityStreamStatus {
    override def unwrap
        : software.amazon.awssdk.services.rds.model.ActivityStreamStatus =
      software.amazon.awssdk.services.rds.model.ActivityStreamStatus.STOPPED
  }
  case object starting extends zio.aws.rds.model.ActivityStreamStatus {
    override def unwrap
        : software.amazon.awssdk.services.rds.model.ActivityStreamStatus =
      software.amazon.awssdk.services.rds.model.ActivityStreamStatus.STARTING
  }
  case object started extends zio.aws.rds.model.ActivityStreamStatus {
    override def unwrap
        : software.amazon.awssdk.services.rds.model.ActivityStreamStatus =
      software.amazon.awssdk.services.rds.model.ActivityStreamStatus.STARTED
  }
  case object stopping extends zio.aws.rds.model.ActivityStreamStatus {
    override def unwrap
        : software.amazon.awssdk.services.rds.model.ActivityStreamStatus =
      software.amazon.awssdk.services.rds.model.ActivityStreamStatus.STOPPING
  }
}
