package zio.aws.rds.model
import zio.aws.rds.model.primitives.DBProxyEndpointName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteDbProxyEndpointRequest(
    dbProxyEndpointName: DBProxyEndpointName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DeleteDbProxyEndpointRequest = {
    import DeleteDbProxyEndpointRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DeleteDbProxyEndpointRequest
      .builder()
      .dbProxyEndpointName(
        DBProxyEndpointName.unwrap(dbProxyEndpointName): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DeleteDbProxyEndpointRequest.ReadOnly =
    zio.aws.rds.model.DeleteDbProxyEndpointRequest.wrap(buildAwsValue())
}
object DeleteDbProxyEndpointRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DeleteDbProxyEndpointRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DeleteDbProxyEndpointRequest =
      zio.aws.rds.model.DeleteDbProxyEndpointRequest(dbProxyEndpointName)
    def dbProxyEndpointName: DBProxyEndpointName
    def getDbProxyEndpointName: ZIO[Any, Nothing, DBProxyEndpointName] =
      ZIO.succeed(dbProxyEndpointName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DeleteDbProxyEndpointRequest
  ) extends zio.aws.rds.model.DeleteDbProxyEndpointRequest.ReadOnly {
    override val dbProxyEndpointName: DBProxyEndpointName =
      zio.aws.rds.model.primitives
        .DBProxyEndpointName(impl.dbProxyEndpointName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DeleteDbProxyEndpointRequest
  ): zio.aws.rds.model.DeleteDbProxyEndpointRequest.ReadOnly = new Wrapper(impl)
}
