package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteDbSecurityGroupRequest(dbSecurityGroupName: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DeleteDbSecurityGroupRequest = {
    import DeleteDbSecurityGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DeleteDbSecurityGroupRequest
      .builder()
      .dbSecurityGroupName(dbSecurityGroupName: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DeleteDbSecurityGroupRequest.ReadOnly =
    zio.aws.rds.model.DeleteDbSecurityGroupRequest.wrap(buildAwsValue())
}
object DeleteDbSecurityGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DeleteDbSecurityGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DeleteDbSecurityGroupRequest =
      zio.aws.rds.model.DeleteDbSecurityGroupRequest(dbSecurityGroupName)
    def dbSecurityGroupName: String
    def getDbSecurityGroupName: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbSecurityGroupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DeleteDbSecurityGroupRequest
  ) extends zio.aws.rds.model.DeleteDbSecurityGroupRequest.ReadOnly {
    override val dbSecurityGroupName: String =
      impl.dbSecurityGroupName(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DeleteDbSecurityGroupRequest
  ): zio.aws.rds.model.DeleteDbSecurityGroupRequest.ReadOnly = new Wrapper(impl)
}
