package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteEventSubscriptionRequest(subscriptionName: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DeleteEventSubscriptionRequest = {
    import DeleteEventSubscriptionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DeleteEventSubscriptionRequest
      .builder()
      .subscriptionName(subscriptionName: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DeleteEventSubscriptionRequest.ReadOnly =
    zio.aws.rds.model.DeleteEventSubscriptionRequest.wrap(buildAwsValue())
}
object DeleteEventSubscriptionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DeleteEventSubscriptionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DeleteEventSubscriptionRequest =
      zio.aws.rds.model.DeleteEventSubscriptionRequest(subscriptionName)
    def subscriptionName: String
    def getSubscriptionName: ZIO[Any, Nothing, String] =
      ZIO.succeed(subscriptionName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DeleteEventSubscriptionRequest
  ) extends zio.aws.rds.model.DeleteEventSubscriptionRequest.ReadOnly {
    override val subscriptionName: String = impl.subscriptionName(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DeleteEventSubscriptionRequest
  ): zio.aws.rds.model.DeleteEventSubscriptionRequest.ReadOnly = new Wrapper(
    impl
  )
}
