package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeDbClusterEndpointsResponse(
    marker: Optional[String] = Optional.Absent,
    dbClusterEndpoints: Optional[
      Iterable[zio.aws.rds.model.DBClusterEndpoint]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DescribeDbClusterEndpointsResponse = {
    import DescribeDbClusterEndpointsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DescribeDbClusterEndpointsResponse
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        dbClusterEndpoints.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dbClusterEndpoints)
      .build()
  }
  def asReadOnly
      : zio.aws.rds.model.DescribeDbClusterEndpointsResponse.ReadOnly =
    zio.aws.rds.model.DescribeDbClusterEndpointsResponse.wrap(buildAwsValue())
}
object DescribeDbClusterEndpointsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DescribeDbClusterEndpointsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DescribeDbClusterEndpointsResponse =
      zio.aws.rds.model.DescribeDbClusterEndpointsResponse(
        marker.map(value => value),
        dbClusterEndpoints.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def marker: Optional[String]
    def dbClusterEndpoints
        : Optional[List[zio.aws.rds.model.DBClusterEndpoint.ReadOnly]]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getDbClusterEndpoints: ZIO[Any, AwsError, List[
      zio.aws.rds.model.DBClusterEndpoint.ReadOnly
    ]] = AwsError.unwrapOptionField("dbClusterEndpoints", dbClusterEndpoints)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DescribeDbClusterEndpointsResponse
  ) extends zio.aws.rds.model.DescribeDbClusterEndpointsResponse.ReadOnly {
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
    override val dbClusterEndpoints
        : Optional[List[zio.aws.rds.model.DBClusterEndpoint.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbClusterEndpoints())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.DBClusterEndpoint.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DescribeDbClusterEndpointsResponse
  ): zio.aws.rds.model.DescribeDbClusterEndpointsResponse.ReadOnly =
    new Wrapper(impl)
}
