package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeReservedDbInstancesOfferingsResponse(
    marker: Optional[String] = Optional.Absent,
    reservedDBInstancesOfferings: Optional[
      Iterable[zio.aws.rds.model.ReservedDBInstancesOffering]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesOfferingsResponse = {
    import DescribeReservedDbInstancesOfferingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesOfferingsResponse
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        reservedDBInstancesOfferings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.reservedDBInstancesOfferings)
      .build()
  }
  def asReadOnly
      : zio.aws.rds.model.DescribeReservedDbInstancesOfferingsResponse.ReadOnly =
    zio.aws.rds.model.DescribeReservedDbInstancesOfferingsResponse
      .wrap(buildAwsValue())
}
object DescribeReservedDbInstancesOfferingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesOfferingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.rds.model.DescribeReservedDbInstancesOfferingsResponse =
      zio.aws.rds.model.DescribeReservedDbInstancesOfferingsResponse(
        marker.map(value => value),
        reservedDBInstancesOfferings.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def marker: Optional[String]
    def reservedDBInstancesOfferings
        : Optional[List[zio.aws.rds.model.ReservedDBInstancesOffering.ReadOnly]]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getReservedDBInstancesOfferings: ZIO[Any, AwsError, List[
      zio.aws.rds.model.ReservedDBInstancesOffering.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "reservedDBInstancesOfferings",
      reservedDBInstancesOfferings
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesOfferingsResponse
  ) extends zio.aws.rds.model.DescribeReservedDbInstancesOfferingsResponse.ReadOnly {
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
    override val reservedDBInstancesOfferings: Optional[
      List[zio.aws.rds.model.ReservedDBInstancesOffering.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.reservedDBInstancesOfferings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rds.model.ReservedDBInstancesOffering.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesOfferingsResponse
  ): zio.aws.rds.model.DescribeReservedDbInstancesOfferingsResponse.ReadOnly =
    new Wrapper(impl)
}
