package zio.aws.rds.model
import scala.jdk.CollectionConverters._
sealed trait EngineFamily {
  def unwrap: software.amazon.awssdk.services.rds.model.EngineFamily
}
object EngineFamily {
  def wrap(
      value: software.amazon.awssdk.services.rds.model.EngineFamily
  ): zio.aws.rds.model.EngineFamily = value match {
    case software.amazon.awssdk.services.rds.model.EngineFamily.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.rds.model.EngineFamily.MYSQL =>
      val r = MYSQL
      r
    case software.amazon.awssdk.services.rds.model.EngineFamily.POSTGRESQL =>
      val r = POSTGRESQL
      r
    case software.amazon.awssdk.services.rds.model.EngineFamily.SQLSERVER =>
      val r = SQLSERVER
      r
  }
  case object unknownToSdkVersion extends zio.aws.rds.model.EngineFamily {
    override def unwrap
        : software.amazon.awssdk.services.rds.model.EngineFamily =
      software.amazon.awssdk.services.rds.model.EngineFamily.UNKNOWN_TO_SDK_VERSION
  }
  case object MYSQL extends zio.aws.rds.model.EngineFamily {
    override def unwrap
        : software.amazon.awssdk.services.rds.model.EngineFamily =
      software.amazon.awssdk.services.rds.model.EngineFamily.MYSQL
  }
  case object POSTGRESQL extends zio.aws.rds.model.EngineFamily {
    override def unwrap
        : software.amazon.awssdk.services.rds.model.EngineFamily =
      software.amazon.awssdk.services.rds.model.EngineFamily.POSTGRESQL
  }
  case object SQLSERVER extends zio.aws.rds.model.EngineFamily {
    override def unwrap
        : software.amazon.awssdk.services.rds.model.EngineFamily =
      software.amazon.awssdk.services.rds.model.EngineFamily.SQLSERVER
  }
}
