package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifyActivityStreamRequest(
    resourceArn: Optional[String] = Optional.Absent,
    auditPolicyState: Optional[zio.aws.rds.model.AuditPolicyState] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.ModifyActivityStreamRequest = {
    import ModifyActivityStreamRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.ModifyActivityStreamRequest
      .builder()
      .optionallyWith(resourceArn.map(value => value: java.lang.String))(
        _.resourceArn
      )
      .optionallyWith(auditPolicyState.map(value => value.unwrap))(
        _.auditPolicyState
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.ModifyActivityStreamRequest.ReadOnly =
    zio.aws.rds.model.ModifyActivityStreamRequest.wrap(buildAwsValue())
}
object ModifyActivityStreamRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.ModifyActivityStreamRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.ModifyActivityStreamRequest =
      zio.aws.rds.model.ModifyActivityStreamRequest(
        resourceArn.map(value => value),
        auditPolicyState.map(value => value)
      )
    def resourceArn: Optional[String]
    def auditPolicyState: Optional[zio.aws.rds.model.AuditPolicyState]
    def getResourceArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceArn", resourceArn)
    def getAuditPolicyState
        : ZIO[Any, AwsError, zio.aws.rds.model.AuditPolicyState] =
      AwsError.unwrapOptionField("auditPolicyState", auditPolicyState)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.ModifyActivityStreamRequest
  ) extends zio.aws.rds.model.ModifyActivityStreamRequest.ReadOnly {
    override val resourceArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceArn())
      .map(value => value: String)
    override val auditPolicyState
        : Optional[zio.aws.rds.model.AuditPolicyState] = zio.aws.core.internal
      .optionalFromNullable(impl.auditPolicyState())
      .map(value => zio.aws.rds.model.AuditPolicyState.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.ModifyActivityStreamRequest
  ): zio.aws.rds.model.ModifyActivityStreamRequest.ReadOnly = new Wrapper(impl)
}
