package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifyDbClusterResponse(
    dbCluster: Optional[zio.aws.rds.model.DBCluster] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.ModifyDbClusterResponse = {
    import ModifyDbClusterResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.ModifyDbClusterResponse
      .builder()
      .optionallyWith(dbCluster.map(value => value.buildAwsValue()))(
        _.dbCluster
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.ModifyDbClusterResponse.ReadOnly =
    zio.aws.rds.model.ModifyDbClusterResponse.wrap(buildAwsValue())
}
object ModifyDbClusterResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.ModifyDbClusterResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.ModifyDbClusterResponse =
      zio.aws.rds.model
        .ModifyDbClusterResponse(dbCluster.map(value => value.asEditable))
    def dbCluster: Optional[zio.aws.rds.model.DBCluster.ReadOnly]
    def getDbCluster: ZIO[Any, AwsError, zio.aws.rds.model.DBCluster.ReadOnly] =
      AwsError.unwrapOptionField("dbCluster", dbCluster)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.ModifyDbClusterResponse
  ) extends zio.aws.rds.model.ModifyDbClusterResponse.ReadOnly {
    override val dbCluster: Optional[zio.aws.rds.model.DBCluster.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbCluster())
        .map(value => zio.aws.rds.model.DBCluster.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.ModifyDbClusterResponse
  ): zio.aws.rds.model.ModifyDbClusterResponse.ReadOnly = new Wrapper(impl)
}
