package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifyDbSubnetGroupResponse(
    dbSubnetGroup: Optional[zio.aws.rds.model.DBSubnetGroup] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.ModifyDbSubnetGroupResponse = {
    import ModifyDbSubnetGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.ModifyDbSubnetGroupResponse
      .builder()
      .optionallyWith(dbSubnetGroup.map(value => value.buildAwsValue()))(
        _.dbSubnetGroup
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.ModifyDbSubnetGroupResponse.ReadOnly =
    zio.aws.rds.model.ModifyDbSubnetGroupResponse.wrap(buildAwsValue())
}
object ModifyDbSubnetGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.ModifyDbSubnetGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.ModifyDbSubnetGroupResponse =
      zio.aws.rds.model.ModifyDbSubnetGroupResponse(
        dbSubnetGroup.map(value => value.asEditable)
      )
    def dbSubnetGroup: Optional[zio.aws.rds.model.DBSubnetGroup.ReadOnly]
    def getDbSubnetGroup
        : ZIO[Any, AwsError, zio.aws.rds.model.DBSubnetGroup.ReadOnly] =
      AwsError.unwrapOptionField("dbSubnetGroup", dbSubnetGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.ModifyDbSubnetGroupResponse
  ) extends zio.aws.rds.model.ModifyDbSubnetGroupResponse.ReadOnly {
    override val dbSubnetGroup
        : Optional[zio.aws.rds.model.DBSubnetGroup.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbSubnetGroup())
        .map(value => zio.aws.rds.model.DBSubnetGroup.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.ModifyDbSubnetGroupResponse
  ): zio.aws.rds.model.ModifyDbSubnetGroupResponse.ReadOnly = new Wrapper(impl)
}
