package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class OptionSetting(
    name: Optional[String] = Optional.Absent,
    value: Optional[String] = Optional.Absent,
    defaultValue: Optional[String] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    applyType: Optional[String] = Optional.Absent,
    dataType: Optional[String] = Optional.Absent,
    allowedValues: Optional[String] = Optional.Absent,
    isModifiable: Optional[Boolean] = Optional.Absent,
    isCollection: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.OptionSetting = {
    import OptionSetting.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.OptionSetting
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(value.map(value => value: java.lang.String))(_.value)
      .optionallyWith(defaultValue.map(value => value: java.lang.String))(
        _.defaultValue
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(applyType.map(value => value: java.lang.String))(
        _.applyType
      )
      .optionallyWith(dataType.map(value => value: java.lang.String))(
        _.dataType
      )
      .optionallyWith(allowedValues.map(value => value: java.lang.String))(
        _.allowedValues
      )
      .optionallyWith(isModifiable.map(value => value: java.lang.Boolean))(
        _.isModifiable
      )
      .optionallyWith(isCollection.map(value => value: java.lang.Boolean))(
        _.isCollection
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.OptionSetting.ReadOnly =
    zio.aws.rds.model.OptionSetting.wrap(buildAwsValue())
}
object OptionSetting {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.rds.model.OptionSetting] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.OptionSetting =
      zio.aws.rds.model.OptionSetting(
        name.map(value => value),
        value.map(value => value),
        defaultValue.map(value => value),
        description.map(value => value),
        applyType.map(value => value),
        dataType.map(value => value),
        allowedValues.map(value => value),
        isModifiable.map(value => value),
        isCollection.map(value => value)
      )
    def name: Optional[String]
    def value: Optional[String]
    def defaultValue: Optional[String]
    def description: Optional[String]
    def applyType: Optional[String]
    def dataType: Optional[String]
    def allowedValues: Optional[String]
    def isModifiable: Optional[Boolean]
    def isCollection: Optional[Boolean]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("value", value)
    def getDefaultValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("defaultValue", defaultValue)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getApplyType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("applyType", applyType)
    def getDataType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dataType", dataType)
    def getAllowedValues: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("allowedValues", allowedValues)
    def getIsModifiable: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isModifiable", isModifiable)
    def getIsCollection: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isCollection", isCollection)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.OptionSetting
  ) extends zio.aws.rds.model.OptionSetting.ReadOnly {
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val value: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => value: String)
    override val defaultValue: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.defaultValue())
      .map(value => value: String)
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val applyType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.applyType())
      .map(value => value: String)
    override val dataType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dataType())
      .map(value => value: String)
    override val allowedValues: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.allowedValues())
      .map(value => value: String)
    override val isModifiable: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isModifiable())
      .map(value => value: Boolean)
    override val isCollection: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isCollection())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.OptionSetting
  ): zio.aws.rds.model.OptionSetting.ReadOnly = new Wrapper(impl)
}
