package zio.aws.rds.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.rds.model.primitives.TStamp
import scala.jdk.CollectionConverters._
final case class RestoreWindow(
    earliestTime: Optional[TStamp] = Optional.Absent,
    latestTime: Optional[TStamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.RestoreWindow = {
    import RestoreWindow.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.RestoreWindow
      .builder()
      .optionallyWith(earliestTime.map(value => TStamp.unwrap(value): Instant))(
        _.earliestTime
      )
      .optionallyWith(latestTime.map(value => TStamp.unwrap(value): Instant))(
        _.latestTime
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.RestoreWindow.ReadOnly =
    zio.aws.rds.model.RestoreWindow.wrap(buildAwsValue())
}
object RestoreWindow {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.rds.model.RestoreWindow] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.RestoreWindow =
      zio.aws.rds.model.RestoreWindow(
        earliestTime.map(value => value),
        latestTime.map(value => value)
      )
    def earliestTime: Optional[TStamp]
    def latestTime: Optional[TStamp]
    def getEarliestTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("earliestTime", earliestTime)
    def getLatestTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("latestTime", latestTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.RestoreWindow
  ) extends zio.aws.rds.model.RestoreWindow.ReadOnly {
    override val earliestTime: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.earliestTime())
      .map(value => zio.aws.rds.model.primitives.TStamp(value))
    override val latestTime: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.latestTime())
      .map(value => zio.aws.rds.model.primitives.TStamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.RestoreWindow
  ): zio.aws.rds.model.RestoreWindow.ReadOnly = new Wrapper(impl)
}
