package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StartDbInstanceAutomatedBackupsReplicationResponse(
    dbInstanceAutomatedBackup: Optional[
      zio.aws.rds.model.DBInstanceAutomatedBackup
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.StartDbInstanceAutomatedBackupsReplicationResponse = {
    import StartDbInstanceAutomatedBackupsReplicationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.StartDbInstanceAutomatedBackupsReplicationResponse
      .builder()
      .optionallyWith(
        dbInstanceAutomatedBackup.map(value => value.buildAwsValue())
      )(_.dbInstanceAutomatedBackup)
      .build()
  }
  def asReadOnly
      : zio.aws.rds.model.StartDbInstanceAutomatedBackupsReplicationResponse.ReadOnly =
    zio.aws.rds.model.StartDbInstanceAutomatedBackupsReplicationResponse
      .wrap(buildAwsValue())
}
object StartDbInstanceAutomatedBackupsReplicationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.StartDbInstanceAutomatedBackupsReplicationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.rds.model.StartDbInstanceAutomatedBackupsReplicationResponse =
      zio.aws.rds.model.StartDbInstanceAutomatedBackupsReplicationResponse(
        dbInstanceAutomatedBackup.map(value => value.asEditable)
      )
    def dbInstanceAutomatedBackup
        : Optional[zio.aws.rds.model.DBInstanceAutomatedBackup.ReadOnly]
    def getDbInstanceAutomatedBackup: ZIO[
      Any,
      AwsError,
      zio.aws.rds.model.DBInstanceAutomatedBackup.ReadOnly
    ] = AwsError.unwrapOptionField(
      "dbInstanceAutomatedBackup",
      dbInstanceAutomatedBackup
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.StartDbInstanceAutomatedBackupsReplicationResponse
  ) extends zio.aws.rds.model.StartDbInstanceAutomatedBackupsReplicationResponse.ReadOnly {
    override val dbInstanceAutomatedBackup
        : Optional[zio.aws.rds.model.DBInstanceAutomatedBackup.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbInstanceAutomatedBackup())
        .map(value => zio.aws.rds.model.DBInstanceAutomatedBackup.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.StartDbInstanceAutomatedBackupsReplicationResponse
  ): zio.aws.rds.model.StartDbInstanceAutomatedBackupsReplicationResponse.ReadOnly =
    new Wrapper(impl)
}
