package zio.aws.rds.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.rds.model.primitives.{BooleanOptional, IntegerOptional}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class CreateDbInstanceReadReplicaRequest(
    dbInstanceIdentifier: String,
    sourceDBInstanceIdentifier: String,
    dbInstanceClass: Optional[String] = Optional.Absent,
    availabilityZone: Optional[String] = Optional.Absent,
    port: Optional[IntegerOptional] = Optional.Absent,
    multiAZ: Optional[BooleanOptional] = Optional.Absent,
    autoMinorVersionUpgrade: Optional[BooleanOptional] = Optional.Absent,
    iops: Optional[IntegerOptional] = Optional.Absent,
    optionGroupName: Optional[String] = Optional.Absent,
    dbParameterGroupName: Optional[String] = Optional.Absent,
    publiclyAccessible: Optional[BooleanOptional] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.rds.model.Tag]] = Optional.Absent,
    dbSubnetGroupName: Optional[String] = Optional.Absent,
    vpcSecurityGroupIds: Optional[Iterable[String]] = Optional.Absent,
    storageType: Optional[String] = Optional.Absent,
    copyTagsToSnapshot: Optional[BooleanOptional] = Optional.Absent,
    monitoringInterval: Optional[IntegerOptional] = Optional.Absent,
    monitoringRoleArn: Optional[String] = Optional.Absent,
    kmsKeyId: Optional[String] = Optional.Absent,
    preSignedUrl: Optional[String] = Optional.Absent,
    enableIAMDatabaseAuthentication: Optional[BooleanOptional] =
      Optional.Absent,
    enablePerformanceInsights: Optional[BooleanOptional] = Optional.Absent,
    performanceInsightsKMSKeyId: Optional[String] = Optional.Absent,
    performanceInsightsRetentionPeriod: Optional[IntegerOptional] =
      Optional.Absent,
    enableCloudwatchLogsExports: Optional[Iterable[String]] = Optional.Absent,
    processorFeatures: Optional[Iterable[zio.aws.rds.model.ProcessorFeature]] =
      Optional.Absent,
    useDefaultProcessorFeatures: Optional[BooleanOptional] = Optional.Absent,
    deletionProtection: Optional[BooleanOptional] = Optional.Absent,
    domain: Optional[String] = Optional.Absent,
    domainIAMRoleName: Optional[String] = Optional.Absent,
    replicaMode: Optional[zio.aws.rds.model.ReplicaMode] = Optional.Absent,
    maxAllocatedStorage: Optional[IntegerOptional] = Optional.Absent,
    customIamInstanceProfile: Optional[String] = Optional.Absent,
    networkType: Optional[String] = Optional.Absent,
    storageThroughput: Optional[IntegerOptional] = Optional.Absent,
    enableCustomerOwnedIp: Optional[BooleanOptional] = Optional.Absent,
    allocatedStorage: Optional[IntegerOptional] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.CreateDbInstanceReadReplicaRequest = {
    import CreateDbInstanceReadReplicaRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.CreateDbInstanceReadReplicaRequest
      .builder()
      .dbInstanceIdentifier(dbInstanceIdentifier: java.lang.String)
      .sourceDBInstanceIdentifier(sourceDBInstanceIdentifier: java.lang.String)
      .optionallyWith(dbInstanceClass.map(value => value: java.lang.String))(
        _.dbInstanceClass
      )
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(port.map(value => value: Integer))(_.port)
      .optionallyWith(multiAZ.map(value => value: java.lang.Boolean))(_.multiAZ)
      .optionallyWith(
        autoMinorVersionUpgrade.map(value => value: java.lang.Boolean)
      )(_.autoMinorVersionUpgrade)
      .optionallyWith(iops.map(value => value: Integer))(_.iops)
      .optionallyWith(optionGroupName.map(value => value: java.lang.String))(
        _.optionGroupName
      )
      .optionallyWith(
        dbParameterGroupName.map(value => value: java.lang.String)
      )(_.dbParameterGroupName)
      .optionallyWith(
        publiclyAccessible.map(value => value: java.lang.Boolean)
      )(_.publiclyAccessible)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(dbSubnetGroupName.map(value => value: java.lang.String))(
        _.dbSubnetGroupName
      )
      .optionallyWith(
        vpcSecurityGroupIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.vpcSecurityGroupIds)
      .optionallyWith(storageType.map(value => value: java.lang.String))(
        _.storageType
      )
      .optionallyWith(
        copyTagsToSnapshot.map(value => value: java.lang.Boolean)
      )(_.copyTagsToSnapshot)
      .optionallyWith(monitoringInterval.map(value => value: Integer))(
        _.monitoringInterval
      )
      .optionallyWith(monitoringRoleArn.map(value => value: java.lang.String))(
        _.monitoringRoleArn
      )
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(preSignedUrl.map(value => value: java.lang.String))(
        _.preSignedUrl
      )
      .optionallyWith(
        enableIAMDatabaseAuthentication.map(value => value: java.lang.Boolean)
      )(_.enableIAMDatabaseAuthentication)
      .optionallyWith(
        enablePerformanceInsights.map(value => value: java.lang.Boolean)
      )(_.enablePerformanceInsights)
      .optionallyWith(
        performanceInsightsKMSKeyId.map(value => value: java.lang.String)
      )(_.performanceInsightsKMSKeyId)
      .optionallyWith(
        performanceInsightsRetentionPeriod.map(value => value: Integer)
      )(_.performanceInsightsRetentionPeriod)
      .optionallyWith(
        enableCloudwatchLogsExports.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.enableCloudwatchLogsExports)
      .optionallyWith(
        processorFeatures.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.processorFeatures)
      .optionallyWith(
        useDefaultProcessorFeatures.map(value => value: java.lang.Boolean)
      )(_.useDefaultProcessorFeatures)
      .optionallyWith(
        deletionProtection.map(value => value: java.lang.Boolean)
      )(_.deletionProtection)
      .optionallyWith(domain.map(value => value: java.lang.String))(_.domain)
      .optionallyWith(domainIAMRoleName.map(value => value: java.lang.String))(
        _.domainIAMRoleName
      )
      .optionallyWith(replicaMode.map(value => value.unwrap))(_.replicaMode)
      .optionallyWith(maxAllocatedStorage.map(value => value: Integer))(
        _.maxAllocatedStorage
      )
      .optionallyWith(
        customIamInstanceProfile.map(value => value: java.lang.String)
      )(_.customIamInstanceProfile)
      .optionallyWith(networkType.map(value => value: java.lang.String))(
        _.networkType
      )
      .optionallyWith(storageThroughput.map(value => value: Integer))(
        _.storageThroughput
      )
      .optionallyWith(
        enableCustomerOwnedIp.map(value => value: java.lang.Boolean)
      )(_.enableCustomerOwnedIp)
      .optionallyWith(allocatedStorage.map(value => value: Integer))(
        _.allocatedStorage
      )
      .build()
  }
  def asReadOnly
      : zio.aws.rds.model.CreateDbInstanceReadReplicaRequest.ReadOnly =
    zio.aws.rds.model.CreateDbInstanceReadReplicaRequest.wrap(buildAwsValue())
}
object CreateDbInstanceReadReplicaRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.CreateDbInstanceReadReplicaRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.CreateDbInstanceReadReplicaRequest =
      zio.aws.rds.model.CreateDbInstanceReadReplicaRequest(
        dbInstanceIdentifier,
        sourceDBInstanceIdentifier,
        dbInstanceClass.map(value => value),
        availabilityZone.map(value => value),
        port.map(value => value),
        multiAZ.map(value => value),
        autoMinorVersionUpgrade.map(value => value),
        iops.map(value => value),
        optionGroupName.map(value => value),
        dbParameterGroupName.map(value => value),
        publiclyAccessible.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        dbSubnetGroupName.map(value => value),
        vpcSecurityGroupIds.map(value => value),
        storageType.map(value => value),
        copyTagsToSnapshot.map(value => value),
        monitoringInterval.map(value => value),
        monitoringRoleArn.map(value => value),
        kmsKeyId.map(value => value),
        preSignedUrl.map(value => value),
        enableIAMDatabaseAuthentication.map(value => value),
        enablePerformanceInsights.map(value => value),
        performanceInsightsKMSKeyId.map(value => value),
        performanceInsightsRetentionPeriod.map(value => value),
        enableCloudwatchLogsExports.map(value => value),
        processorFeatures.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        useDefaultProcessorFeatures.map(value => value),
        deletionProtection.map(value => value),
        domain.map(value => value),
        domainIAMRoleName.map(value => value),
        replicaMode.map(value => value),
        maxAllocatedStorage.map(value => value),
        customIamInstanceProfile.map(value => value),
        networkType.map(value => value),
        storageThroughput.map(value => value),
        enableCustomerOwnedIp.map(value => value),
        allocatedStorage.map(value => value)
      )
    def dbInstanceIdentifier: String
    def sourceDBInstanceIdentifier: String
    def dbInstanceClass: Optional[String]
    def availabilityZone: Optional[String]
    def port: Optional[IntegerOptional]
    def multiAZ: Optional[BooleanOptional]
    def autoMinorVersionUpgrade: Optional[BooleanOptional]
    def iops: Optional[IntegerOptional]
    def optionGroupName: Optional[String]
    def dbParameterGroupName: Optional[String]
    def publiclyAccessible: Optional[BooleanOptional]
    def tags: Optional[List[zio.aws.rds.model.Tag.ReadOnly]]
    def dbSubnetGroupName: Optional[String]
    def vpcSecurityGroupIds: Optional[List[String]]
    def storageType: Optional[String]
    def copyTagsToSnapshot: Optional[BooleanOptional]
    def monitoringInterval: Optional[IntegerOptional]
    def monitoringRoleArn: Optional[String]
    def kmsKeyId: Optional[String]
    def preSignedUrl: Optional[String]
    def enableIAMDatabaseAuthentication: Optional[BooleanOptional]
    def enablePerformanceInsights: Optional[BooleanOptional]
    def performanceInsightsKMSKeyId: Optional[String]
    def performanceInsightsRetentionPeriod: Optional[IntegerOptional]
    def enableCloudwatchLogsExports: Optional[List[String]]
    def processorFeatures
        : Optional[List[zio.aws.rds.model.ProcessorFeature.ReadOnly]]
    def useDefaultProcessorFeatures: Optional[BooleanOptional]
    def deletionProtection: Optional[BooleanOptional]
    def domain: Optional[String]
    def domainIAMRoleName: Optional[String]
    def replicaMode: Optional[zio.aws.rds.model.ReplicaMode]
    def maxAllocatedStorage: Optional[IntegerOptional]
    def customIamInstanceProfile: Optional[String]
    def networkType: Optional[String]
    def storageThroughput: Optional[IntegerOptional]
    def enableCustomerOwnedIp: Optional[BooleanOptional]
    def allocatedStorage: Optional[IntegerOptional]
    def getDbInstanceIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbInstanceIdentifier)
    def getSourceDBInstanceIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(sourceDBInstanceIdentifier)
    def getDbInstanceClass: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbInstanceClass", dbInstanceClass)
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getPort: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("port", port)
    def getMultiAZ: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("multiAZ", multiAZ)
    def getAutoMinorVersionUpgrade: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "autoMinorVersionUpgrade",
        autoMinorVersionUpgrade
      )
    def getIops: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("iops", iops)
    def getOptionGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("optionGroupName", optionGroupName)
    def getDbParameterGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbParameterGroupName", dbParameterGroupName)
    def getPubliclyAccessible: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("publiclyAccessible", publiclyAccessible)
    def getTags: ZIO[Any, AwsError, List[zio.aws.rds.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getDbSubnetGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbSubnetGroupName", dbSubnetGroupName)
    def getVpcSecurityGroupIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("vpcSecurityGroupIds", vpcSecurityGroupIds)
    def getStorageType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("storageType", storageType)
    def getCopyTagsToSnapshot: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("copyTagsToSnapshot", copyTagsToSnapshot)
    def getMonitoringInterval: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("monitoringInterval", monitoringInterval)
    def getMonitoringRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("monitoringRoleArn", monitoringRoleArn)
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getPreSignedUrl: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("preSignedUrl", preSignedUrl)
    def getEnableIAMDatabaseAuthentication
        : ZIO[Any, AwsError, BooleanOptional] = AwsError.unwrapOptionField(
      "enableIAMDatabaseAuthentication",
      enableIAMDatabaseAuthentication
    )
    def getEnablePerformanceInsights: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "enablePerformanceInsights",
        enablePerformanceInsights
      )
    def getPerformanceInsightsKMSKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "performanceInsightsKMSKeyId",
        performanceInsightsKMSKeyId
      )
    def getPerformanceInsightsRetentionPeriod
        : ZIO[Any, AwsError, IntegerOptional] = AwsError.unwrapOptionField(
      "performanceInsightsRetentionPeriod",
      performanceInsightsRetentionPeriod
    )
    def getEnableCloudwatchLogsExports: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField(
        "enableCloudwatchLogsExports",
        enableCloudwatchLogsExports
      )
    def getProcessorFeatures: ZIO[Any, AwsError, List[
      zio.aws.rds.model.ProcessorFeature.ReadOnly
    ]] = AwsError.unwrapOptionField("processorFeatures", processorFeatures)
    def getUseDefaultProcessorFeatures: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "useDefaultProcessorFeatures",
        useDefaultProcessorFeatures
      )
    def getDeletionProtection: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("deletionProtection", deletionProtection)
    def getDomain: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("domain", domain)
    def getDomainIAMRoleName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("domainIAMRoleName", domainIAMRoleName)
    def getReplicaMode: ZIO[Any, AwsError, zio.aws.rds.model.ReplicaMode] =
      AwsError.unwrapOptionField("replicaMode", replicaMode)
    def getMaxAllocatedStorage: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxAllocatedStorage", maxAllocatedStorage)
    def getCustomIamInstanceProfile: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("customIamInstanceProfile", customIamInstanceProfile)
    def getNetworkType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("networkType", networkType)
    def getStorageThroughput: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("storageThroughput", storageThroughput)
    def getEnableCustomerOwnedIp: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("enableCustomerOwnedIp", enableCustomerOwnedIp)
    def getAllocatedStorage: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("allocatedStorage", allocatedStorage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.CreateDbInstanceReadReplicaRequest
  ) extends zio.aws.rds.model.CreateDbInstanceReadReplicaRequest.ReadOnly {
    override val dbInstanceIdentifier: String =
      impl.dbInstanceIdentifier(): String
    override val sourceDBInstanceIdentifier: String =
      impl.sourceDBInstanceIdentifier(): String
    override val dbInstanceClass: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbInstanceClass())
      .map(value => value: String)
    override val availabilityZone: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.availabilityZone())
      .map(value => value: String)
    override val port: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.port())
      .map(value => value: IntegerOptional)
    override val multiAZ: Optional[BooleanOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.multiAZ())
      .map(value => value: BooleanOptional)
    override val autoMinorVersionUpgrade: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoMinorVersionUpgrade())
        .map(value => value: BooleanOptional)
    override val iops: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.iops())
      .map(value => value: IntegerOptional)
    override val optionGroupName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.optionGroupName())
      .map(value => value: String)
    override val dbParameterGroupName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbParameterGroupName())
      .map(value => value: String)
    override val publiclyAccessible: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.publiclyAccessible())
        .map(value => value: BooleanOptional)
    override val tags: Optional[List[zio.aws.rds.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.Tag.wrap(item)
          }.toList
        )
    override val dbSubnetGroupName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbSubnetGroupName())
      .map(value => value: String)
    override val vpcSecurityGroupIds: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcSecurityGroupIds())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val storageType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.storageType())
      .map(value => value: String)
    override val copyTagsToSnapshot: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.copyTagsToSnapshot())
        .map(value => value: BooleanOptional)
    override val monitoringInterval: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.monitoringInterval())
        .map(value => value: IntegerOptional)
    override val monitoringRoleArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.monitoringRoleArn())
      .map(value => value: String)
    override val kmsKeyId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => value: String)
    override val preSignedUrl: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.preSignedUrl())
      .map(value => value: String)
    override val enableIAMDatabaseAuthentication: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableIAMDatabaseAuthentication())
        .map(value => value: BooleanOptional)
    override val enablePerformanceInsights: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enablePerformanceInsights())
        .map(value => value: BooleanOptional)
    override val performanceInsightsKMSKeyId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.performanceInsightsKMSKeyId())
        .map(value => value: String)
    override val performanceInsightsRetentionPeriod: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.performanceInsightsRetentionPeriod())
        .map(value => value: IntegerOptional)
    override val enableCloudwatchLogsExports: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableCloudwatchLogsExports())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val processorFeatures
        : Optional[List[zio.aws.rds.model.ProcessorFeature.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.processorFeatures())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.ProcessorFeature.wrap(item)
          }.toList
        )
    override val useDefaultProcessorFeatures: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.useDefaultProcessorFeatures())
        .map(value => value: BooleanOptional)
    override val deletionProtection: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deletionProtection())
        .map(value => value: BooleanOptional)
    override val domain: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.domain())
      .map(value => value: String)
    override val domainIAMRoleName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.domainIAMRoleName())
      .map(value => value: String)
    override val replicaMode: Optional[zio.aws.rds.model.ReplicaMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicaMode())
        .map(value => zio.aws.rds.model.ReplicaMode.wrap(value))
    override val maxAllocatedStorage: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxAllocatedStorage())
        .map(value => value: IntegerOptional)
    override val customIamInstanceProfile: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customIamInstanceProfile())
        .map(value => value: String)
    override val networkType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.networkType())
      .map(value => value: String)
    override val storageThroughput: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storageThroughput())
        .map(value => value: IntegerOptional)
    override val enableCustomerOwnedIp: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableCustomerOwnedIp())
        .map(value => value: BooleanOptional)
    override val allocatedStorage: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.allocatedStorage())
        .map(value => value: IntegerOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.CreateDbInstanceReadReplicaRequest
  ): zio.aws.rds.model.CreateDbInstanceReadReplicaRequest.ReadOnly =
    new Wrapper(impl)
}
