package zio.aws.rds.model
import zio.aws.rds.model.primitives.{DBProxyEndpointName, DBProxyName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateDbProxyEndpointRequest(
    dbProxyName: DBProxyName,
    dbProxyEndpointName: DBProxyEndpointName,
    vpcSubnetIds: Iterable[String],
    vpcSecurityGroupIds: Optional[Iterable[String]] = Optional.Absent,
    targetRole: Optional[zio.aws.rds.model.DBProxyEndpointTargetRole] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.rds.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.CreateDbProxyEndpointRequest = {
    import CreateDbProxyEndpointRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.CreateDbProxyEndpointRequest
      .builder()
      .dbProxyName(DBProxyName.unwrap(dbProxyName): java.lang.String)
      .dbProxyEndpointName(
        DBProxyEndpointName.unwrap(dbProxyEndpointName): java.lang.String
      )
      .vpcSubnetIds(vpcSubnetIds.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        vpcSecurityGroupIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.vpcSecurityGroupIds)
      .optionallyWith(targetRole.map(value => value.unwrap))(_.targetRole)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.CreateDbProxyEndpointRequest.ReadOnly =
    zio.aws.rds.model.CreateDbProxyEndpointRequest.wrap(buildAwsValue())
}
object CreateDbProxyEndpointRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.CreateDbProxyEndpointRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.CreateDbProxyEndpointRequest =
      zio.aws.rds.model.CreateDbProxyEndpointRequest(
        dbProxyName,
        dbProxyEndpointName,
        vpcSubnetIds,
        vpcSecurityGroupIds.map(value => value),
        targetRole.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def dbProxyName: DBProxyName
    def dbProxyEndpointName: DBProxyEndpointName
    def vpcSubnetIds: List[String]
    def vpcSecurityGroupIds: Optional[List[String]]
    def targetRole: Optional[zio.aws.rds.model.DBProxyEndpointTargetRole]
    def tags: Optional[List[zio.aws.rds.model.Tag.ReadOnly]]
    def getDbProxyName: ZIO[Any, Nothing, DBProxyName] =
      ZIO.succeed(dbProxyName)
    def getDbProxyEndpointName: ZIO[Any, Nothing, DBProxyEndpointName] =
      ZIO.succeed(dbProxyEndpointName)
    def getVpcSubnetIds: ZIO[Any, Nothing, List[String]] =
      ZIO.succeed(vpcSubnetIds)
    def getVpcSecurityGroupIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("vpcSecurityGroupIds", vpcSecurityGroupIds)
    def getTargetRole
        : ZIO[Any, AwsError, zio.aws.rds.model.DBProxyEndpointTargetRole] =
      AwsError.unwrapOptionField("targetRole", targetRole)
    def getTags: ZIO[Any, AwsError, List[zio.aws.rds.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.CreateDbProxyEndpointRequest
  ) extends zio.aws.rds.model.CreateDbProxyEndpointRequest.ReadOnly {
    override val dbProxyName: DBProxyName =
      zio.aws.rds.model.primitives.DBProxyName(impl.dbProxyName())
    override val dbProxyEndpointName: DBProxyEndpointName =
      zio.aws.rds.model.primitives
        .DBProxyEndpointName(impl.dbProxyEndpointName())
    override val vpcSubnetIds: List[String] = impl
      .vpcSubnetIds()
      .asScala
      .map { item =>
        item: String
      }
      .toList
    override val vpcSecurityGroupIds: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcSecurityGroupIds())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val targetRole
        : Optional[zio.aws.rds.model.DBProxyEndpointTargetRole] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetRole())
        .map(value => zio.aws.rds.model.DBProxyEndpointTargetRole.wrap(value))
    override val tags: Optional[List[zio.aws.rds.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.CreateDbProxyEndpointRequest
  ): zio.aws.rds.model.CreateDbProxyEndpointRequest.ReadOnly = new Wrapper(impl)
}
