package zio.aws.rds.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.rds.model.primitives.TStamp
import scala.jdk.CollectionConverters._
final case class DBClusterBacktrack(
    dbClusterIdentifier: Optional[String] = Optional.Absent,
    backtrackIdentifier: Optional[String] = Optional.Absent,
    backtrackTo: Optional[TStamp] = Optional.Absent,
    backtrackedFrom: Optional[TStamp] = Optional.Absent,
    backtrackRequestCreationTime: Optional[TStamp] = Optional.Absent,
    status: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DBClusterBacktrack = {
    import DBClusterBacktrack.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DBClusterBacktrack
      .builder()
      .optionallyWith(
        dbClusterIdentifier.map(value => value: java.lang.String)
      )(_.dbClusterIdentifier)
      .optionallyWith(
        backtrackIdentifier.map(value => value: java.lang.String)
      )(_.backtrackIdentifier)
      .optionallyWith(backtrackTo.map(value => TStamp.unwrap(value): Instant))(
        _.backtrackTo
      )
      .optionallyWith(
        backtrackedFrom.map(value => TStamp.unwrap(value): Instant)
      )(_.backtrackedFrom)
      .optionallyWith(
        backtrackRequestCreationTime.map(value => TStamp.unwrap(value): Instant)
      )(_.backtrackRequestCreationTime)
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DBClusterBacktrack.ReadOnly =
    zio.aws.rds.model.DBClusterBacktrack.wrap(buildAwsValue())
}
object DBClusterBacktrack {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DBClusterBacktrack
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DBClusterBacktrack =
      zio.aws.rds.model.DBClusterBacktrack(
        dbClusterIdentifier.map(value => value),
        backtrackIdentifier.map(value => value),
        backtrackTo.map(value => value),
        backtrackedFrom.map(value => value),
        backtrackRequestCreationTime.map(value => value),
        status.map(value => value)
      )
    def dbClusterIdentifier: Optional[String]
    def backtrackIdentifier: Optional[String]
    def backtrackTo: Optional[TStamp]
    def backtrackedFrom: Optional[TStamp]
    def backtrackRequestCreationTime: Optional[TStamp]
    def status: Optional[String]
    def getDbClusterIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbClusterIdentifier", dbClusterIdentifier)
    def getBacktrackIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("backtrackIdentifier", backtrackIdentifier)
    def getBacktrackTo: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("backtrackTo", backtrackTo)
    def getBacktrackedFrom: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("backtrackedFrom", backtrackedFrom)
    def getBacktrackRequestCreationTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField(
        "backtrackRequestCreationTime",
        backtrackRequestCreationTime
      )
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DBClusterBacktrack
  ) extends zio.aws.rds.model.DBClusterBacktrack.ReadOnly {
    override val dbClusterIdentifier: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbClusterIdentifier())
      .map(value => value: String)
    override val backtrackIdentifier: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.backtrackIdentifier())
      .map(value => value: String)
    override val backtrackTo: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.backtrackTo())
      .map(value => zio.aws.rds.model.primitives.TStamp(value))
    override val backtrackedFrom: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.backtrackedFrom())
      .map(value => zio.aws.rds.model.primitives.TStamp(value))
    override val backtrackRequestCreationTime: Optional[TStamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.backtrackRequestCreationTime())
        .map(value => zio.aws.rds.model.primitives.TStamp(value))
    override val status: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DBClusterBacktrack
  ): zio.aws.rds.model.DBClusterBacktrack.ReadOnly = new Wrapper(impl)
}
