package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DBClusterOptionGroupStatus(
    dbClusterOptionGroupName: Optional[String] = Optional.Absent,
    status: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DBClusterOptionGroupStatus = {
    import DBClusterOptionGroupStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DBClusterOptionGroupStatus
      .builder()
      .optionallyWith(
        dbClusterOptionGroupName.map(value => value: java.lang.String)
      )(_.dbClusterOptionGroupName)
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DBClusterOptionGroupStatus.ReadOnly =
    zio.aws.rds.model.DBClusterOptionGroupStatus.wrap(buildAwsValue())
}
object DBClusterOptionGroupStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DBClusterOptionGroupStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DBClusterOptionGroupStatus =
      zio.aws.rds.model.DBClusterOptionGroupStatus(
        dbClusterOptionGroupName.map(value => value),
        status.map(value => value)
      )
    def dbClusterOptionGroupName: Optional[String]
    def status: Optional[String]
    def getDbClusterOptionGroupName: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("dbClusterOptionGroupName", dbClusterOptionGroupName)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DBClusterOptionGroupStatus
  ) extends zio.aws.rds.model.DBClusterOptionGroupStatus.ReadOnly {
    override val dbClusterOptionGroupName: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbClusterOptionGroupName())
        .map(value => value: String)
    override val status: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DBClusterOptionGroupStatus
  ): zio.aws.rds.model.DBClusterOptionGroupStatus.ReadOnly = new Wrapper(impl)
}
