package zio.aws.rds.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.rds.model.primitives.{Integer, TStamp}
import scala.jdk.CollectionConverters._
final case class DBClusterSnapshot(
    availabilityZones: Optional[Iterable[String]] = Optional.Absent,
    dbClusterSnapshotIdentifier: Optional[String] = Optional.Absent,
    dbClusterIdentifier: Optional[String] = Optional.Absent,
    snapshotCreateTime: Optional[TStamp] = Optional.Absent,
    engine: Optional[String] = Optional.Absent,
    engineMode: Optional[String] = Optional.Absent,
    allocatedStorage: Optional[Integer] = Optional.Absent,
    status: Optional[String] = Optional.Absent,
    port: Optional[Integer] = Optional.Absent,
    vpcId: Optional[String] = Optional.Absent,
    clusterCreateTime: Optional[TStamp] = Optional.Absent,
    masterUsername: Optional[String] = Optional.Absent,
    engineVersion: Optional[String] = Optional.Absent,
    licenseModel: Optional[String] = Optional.Absent,
    snapshotType: Optional[String] = Optional.Absent,
    percentProgress: Optional[Integer] = Optional.Absent,
    storageEncrypted: Optional[Boolean] = Optional.Absent,
    kmsKeyId: Optional[String] = Optional.Absent,
    dbClusterSnapshotArn: Optional[String] = Optional.Absent,
    sourceDBClusterSnapshotArn: Optional[String] = Optional.Absent,
    iamDatabaseAuthenticationEnabled: Optional[Boolean] = Optional.Absent,
    tagList: Optional[Iterable[zio.aws.rds.model.Tag]] = Optional.Absent,
    dbSystemId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DBClusterSnapshot = {
    import DBClusterSnapshot.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DBClusterSnapshot
      .builder()
      .optionallyWith(
        availabilityZones.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.availabilityZones)
      .optionallyWith(
        dbClusterSnapshotIdentifier.map(value => value: java.lang.String)
      )(_.dbClusterSnapshotIdentifier)
      .optionallyWith(
        dbClusterIdentifier.map(value => value: java.lang.String)
      )(_.dbClusterIdentifier)
      .optionallyWith(
        snapshotCreateTime.map(value => TStamp.unwrap(value): Instant)
      )(_.snapshotCreateTime)
      .optionallyWith(engine.map(value => value: java.lang.String))(_.engine)
      .optionallyWith(engineMode.map(value => value: java.lang.String))(
        _.engineMode
      )
      .optionallyWith(allocatedStorage.map(value => value: java.lang.Integer))(
        _.allocatedStorage
      )
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(port.map(value => value: java.lang.Integer))(_.port)
      .optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId)
      .optionallyWith(
        clusterCreateTime.map(value => TStamp.unwrap(value): Instant)
      )(_.clusterCreateTime)
      .optionallyWith(masterUsername.map(value => value: java.lang.String))(
        _.masterUsername
      )
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(licenseModel.map(value => value: java.lang.String))(
        _.licenseModel
      )
      .optionallyWith(snapshotType.map(value => value: java.lang.String))(
        _.snapshotType
      )
      .optionallyWith(percentProgress.map(value => value: java.lang.Integer))(
        _.percentProgress
      )
      .optionallyWith(storageEncrypted.map(value => value: java.lang.Boolean))(
        _.storageEncrypted
      )
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(
        dbClusterSnapshotArn.map(value => value: java.lang.String)
      )(_.dbClusterSnapshotArn)
      .optionallyWith(
        sourceDBClusterSnapshotArn.map(value => value: java.lang.String)
      )(_.sourceDBClusterSnapshotArn)
      .optionallyWith(
        iamDatabaseAuthenticationEnabled.map(value => value: java.lang.Boolean)
      )(_.iamDatabaseAuthenticationEnabled)
      .optionallyWith(
        tagList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagList)
      .optionallyWith(dbSystemId.map(value => value: java.lang.String))(
        _.dbSystemId
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DBClusterSnapshot.ReadOnly =
    zio.aws.rds.model.DBClusterSnapshot.wrap(buildAwsValue())
}
object DBClusterSnapshot {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DBClusterSnapshot
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DBClusterSnapshot =
      zio.aws.rds.model.DBClusterSnapshot(
        availabilityZones.map(value => value),
        dbClusterSnapshotIdentifier.map(value => value),
        dbClusterIdentifier.map(value => value),
        snapshotCreateTime.map(value => value),
        engine.map(value => value),
        engineMode.map(value => value),
        allocatedStorage.map(value => value),
        status.map(value => value),
        port.map(value => value),
        vpcId.map(value => value),
        clusterCreateTime.map(value => value),
        masterUsername.map(value => value),
        engineVersion.map(value => value),
        licenseModel.map(value => value),
        snapshotType.map(value => value),
        percentProgress.map(value => value),
        storageEncrypted.map(value => value),
        kmsKeyId.map(value => value),
        dbClusterSnapshotArn.map(value => value),
        sourceDBClusterSnapshotArn.map(value => value),
        iamDatabaseAuthenticationEnabled.map(value => value),
        tagList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        dbSystemId.map(value => value)
      )
    def availabilityZones: Optional[List[String]]
    def dbClusterSnapshotIdentifier: Optional[String]
    def dbClusterIdentifier: Optional[String]
    def snapshotCreateTime: Optional[TStamp]
    def engine: Optional[String]
    def engineMode: Optional[String]
    def allocatedStorage: Optional[Integer]
    def status: Optional[String]
    def port: Optional[Integer]
    def vpcId: Optional[String]
    def clusterCreateTime: Optional[TStamp]
    def masterUsername: Optional[String]
    def engineVersion: Optional[String]
    def licenseModel: Optional[String]
    def snapshotType: Optional[String]
    def percentProgress: Optional[Integer]
    def storageEncrypted: Optional[Boolean]
    def kmsKeyId: Optional[String]
    def dbClusterSnapshotArn: Optional[String]
    def sourceDBClusterSnapshotArn: Optional[String]
    def iamDatabaseAuthenticationEnabled: Optional[Boolean]
    def tagList: Optional[List[zio.aws.rds.model.Tag.ReadOnly]]
    def dbSystemId: Optional[String]
    def getAvailabilityZones: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("availabilityZones", availabilityZones)
    def getDbClusterSnapshotIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "dbClusterSnapshotIdentifier",
        dbClusterSnapshotIdentifier
      )
    def getDbClusterIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbClusterIdentifier", dbClusterIdentifier)
    def getSnapshotCreateTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("snapshotCreateTime", snapshotCreateTime)
    def getEngine: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engine", engine)
    def getEngineMode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineMode", engineMode)
    def getAllocatedStorage: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("allocatedStorage", allocatedStorage)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("port", port)
    def getVpcId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getClusterCreateTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("clusterCreateTime", clusterCreateTime)
    def getMasterUsername: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("masterUsername", masterUsername)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getLicenseModel: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("licenseModel", licenseModel)
    def getSnapshotType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotType", snapshotType)
    def getPercentProgress: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("percentProgress", percentProgress)
    def getStorageEncrypted: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("storageEncrypted", storageEncrypted)
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getDbClusterSnapshotArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbClusterSnapshotArn", dbClusterSnapshotArn)
    def getSourceDBClusterSnapshotArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "sourceDBClusterSnapshotArn",
        sourceDBClusterSnapshotArn
      )
    def getIamDatabaseAuthenticationEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "iamDatabaseAuthenticationEnabled",
        iamDatabaseAuthenticationEnabled
      )
    def getTagList: ZIO[Any, AwsError, List[zio.aws.rds.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tagList", tagList)
    def getDbSystemId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbSystemId", dbSystemId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DBClusterSnapshot
  ) extends zio.aws.rds.model.DBClusterSnapshot.ReadOnly {
    override val availabilityZones: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.availabilityZones())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val dbClusterSnapshotIdentifier: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbClusterSnapshotIdentifier())
        .map(value => value: String)
    override val dbClusterIdentifier: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbClusterIdentifier())
      .map(value => value: String)
    override val snapshotCreateTime: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.snapshotCreateTime())
      .map(value => zio.aws.rds.model.primitives.TStamp(value))
    override val engine: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engine())
      .map(value => value: String)
    override val engineMode: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engineMode())
      .map(value => value: String)
    override val allocatedStorage: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.allocatedStorage())
      .map(value => value: Integer)
    override val status: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => value: String)
    override val port: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.port())
      .map(value => value: Integer)
    override val vpcId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value => value: String)
    override val clusterCreateTime: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterCreateTime())
      .map(value => zio.aws.rds.model.primitives.TStamp(value))
    override val masterUsername: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.masterUsername())
      .map(value => value: String)
    override val engineVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engineVersion())
      .map(value => value: String)
    override val licenseModel: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.licenseModel())
      .map(value => value: String)
    override val snapshotType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.snapshotType())
      .map(value => value: String)
    override val percentProgress: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.percentProgress())
      .map(value => value: Integer)
    override val storageEncrypted: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.storageEncrypted())
      .map(value => value: Boolean)
    override val kmsKeyId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => value: String)
    override val dbClusterSnapshotArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbClusterSnapshotArn())
      .map(value => value: String)
    override val sourceDBClusterSnapshotArn: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceDBClusterSnapshotArn())
        .map(value => value: String)
    override val iamDatabaseAuthenticationEnabled: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.iamDatabaseAuthenticationEnabled())
        .map(value => value: Boolean)
    override val tagList: Optional[List[zio.aws.rds.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tagList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.Tag.wrap(item)
          }.toList
        )
    override val dbSystemId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbSystemId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DBClusterSnapshot
  ): zio.aws.rds.model.DBClusterSnapshot.ReadOnly = new Wrapper(impl)
}
