package zio.aws.rds.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.rds.model.primitives.TStamp
import scala.jdk.CollectionConverters._
final case class DBProxyEndpoint(
    dbProxyEndpointName: Optional[String] = Optional.Absent,
    dbProxyEndpointArn: Optional[String] = Optional.Absent,
    dbProxyName: Optional[String] = Optional.Absent,
    status: Optional[zio.aws.rds.model.DBProxyEndpointStatus] = Optional.Absent,
    vpcId: Optional[String] = Optional.Absent,
    vpcSecurityGroupIds: Optional[Iterable[String]] = Optional.Absent,
    vpcSubnetIds: Optional[Iterable[String]] = Optional.Absent,
    endpoint: Optional[String] = Optional.Absent,
    createdDate: Optional[TStamp] = Optional.Absent,
    targetRole: Optional[zio.aws.rds.model.DBProxyEndpointTargetRole] =
      Optional.Absent,
    isDefault: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DBProxyEndpoint = {
    import DBProxyEndpoint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DBProxyEndpoint
      .builder()
      .optionallyWith(
        dbProxyEndpointName.map(value => value: java.lang.String)
      )(_.dbProxyEndpointName)
      .optionallyWith(dbProxyEndpointArn.map(value => value: java.lang.String))(
        _.dbProxyEndpointArn
      )
      .optionallyWith(dbProxyName.map(value => value: java.lang.String))(
        _.dbProxyName
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId)
      .optionallyWith(
        vpcSecurityGroupIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.vpcSecurityGroupIds)
      .optionallyWith(
        vpcSubnetIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.vpcSubnetIds)
      .optionallyWith(endpoint.map(value => value: java.lang.String))(
        _.endpoint
      )
      .optionallyWith(createdDate.map(value => TStamp.unwrap(value): Instant))(
        _.createdDate
      )
      .optionallyWith(targetRole.map(value => value.unwrap))(_.targetRole)
      .optionallyWith(isDefault.map(value => value: java.lang.Boolean))(
        _.isDefault
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DBProxyEndpoint.ReadOnly =
    zio.aws.rds.model.DBProxyEndpoint.wrap(buildAwsValue())
}
object DBProxyEndpoint {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DBProxyEndpoint
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DBProxyEndpoint =
      zio.aws.rds.model.DBProxyEndpoint(
        dbProxyEndpointName.map(value => value),
        dbProxyEndpointArn.map(value => value),
        dbProxyName.map(value => value),
        status.map(value => value),
        vpcId.map(value => value),
        vpcSecurityGroupIds.map(value => value),
        vpcSubnetIds.map(value => value),
        endpoint.map(value => value),
        createdDate.map(value => value),
        targetRole.map(value => value),
        isDefault.map(value => value)
      )
    def dbProxyEndpointName: Optional[String]
    def dbProxyEndpointArn: Optional[String]
    def dbProxyName: Optional[String]
    def status: Optional[zio.aws.rds.model.DBProxyEndpointStatus]
    def vpcId: Optional[String]
    def vpcSecurityGroupIds: Optional[List[String]]
    def vpcSubnetIds: Optional[List[String]]
    def endpoint: Optional[String]
    def createdDate: Optional[TStamp]
    def targetRole: Optional[zio.aws.rds.model.DBProxyEndpointTargetRole]
    def isDefault: Optional[Boolean]
    def getDbProxyEndpointName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbProxyEndpointName", dbProxyEndpointName)
    def getDbProxyEndpointArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbProxyEndpointArn", dbProxyEndpointArn)
    def getDbProxyName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbProxyName", dbProxyName)
    def getStatus: ZIO[Any, AwsError, zio.aws.rds.model.DBProxyEndpointStatus] =
      AwsError.unwrapOptionField("status", status)
    def getVpcId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getVpcSecurityGroupIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("vpcSecurityGroupIds", vpcSecurityGroupIds)
    def getVpcSubnetIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("vpcSubnetIds", vpcSubnetIds)
    def getEndpoint: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("endpoint", endpoint)
    def getCreatedDate: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("createdDate", createdDate)
    def getTargetRole
        : ZIO[Any, AwsError, zio.aws.rds.model.DBProxyEndpointTargetRole] =
      AwsError.unwrapOptionField("targetRole", targetRole)
    def getIsDefault: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isDefault", isDefault)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DBProxyEndpoint
  ) extends zio.aws.rds.model.DBProxyEndpoint.ReadOnly {
    override val dbProxyEndpointName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbProxyEndpointName())
      .map(value => value: String)
    override val dbProxyEndpointArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbProxyEndpointArn())
      .map(value => value: String)
    override val dbProxyName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbProxyName())
      .map(value => value: String)
    override val status: Optional[zio.aws.rds.model.DBProxyEndpointStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.rds.model.DBProxyEndpointStatus.wrap(value))
    override val vpcId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value => value: String)
    override val vpcSecurityGroupIds: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcSecurityGroupIds())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val vpcSubnetIds: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcSubnetIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val endpoint: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.endpoint())
      .map(value => value: String)
    override val createdDate: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdDate())
      .map(value => zio.aws.rds.model.primitives.TStamp(value))
    override val targetRole
        : Optional[zio.aws.rds.model.DBProxyEndpointTargetRole] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetRole())
        .map(value => zio.aws.rds.model.DBProxyEndpointTargetRole.wrap(value))
    override val isDefault: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isDefault())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DBProxyEndpoint
  ): zio.aws.rds.model.DBProxyEndpoint.ReadOnly = new Wrapper(impl)
}
