package zio.aws.rds.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.rds.model.primitives.TStamp
import scala.jdk.CollectionConverters._
final case class DBProxyTargetGroup(
    dbProxyName: Optional[String] = Optional.Absent,
    targetGroupName: Optional[String] = Optional.Absent,
    targetGroupArn: Optional[String] = Optional.Absent,
    isDefault: Optional[Boolean] = Optional.Absent,
    status: Optional[String] = Optional.Absent,
    connectionPoolConfig: Optional[
      zio.aws.rds.model.ConnectionPoolConfigurationInfo
    ] = Optional.Absent,
    createdDate: Optional[TStamp] = Optional.Absent,
    updatedDate: Optional[TStamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DBProxyTargetGroup = {
    import DBProxyTargetGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DBProxyTargetGroup
      .builder()
      .optionallyWith(dbProxyName.map(value => value: java.lang.String))(
        _.dbProxyName
      )
      .optionallyWith(targetGroupName.map(value => value: java.lang.String))(
        _.targetGroupName
      )
      .optionallyWith(targetGroupArn.map(value => value: java.lang.String))(
        _.targetGroupArn
      )
      .optionallyWith(isDefault.map(value => value: java.lang.Boolean))(
        _.isDefault
      )
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(connectionPoolConfig.map(value => value.buildAwsValue()))(
        _.connectionPoolConfig
      )
      .optionallyWith(createdDate.map(value => TStamp.unwrap(value): Instant))(
        _.createdDate
      )
      .optionallyWith(updatedDate.map(value => TStamp.unwrap(value): Instant))(
        _.updatedDate
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DBProxyTargetGroup.ReadOnly =
    zio.aws.rds.model.DBProxyTargetGroup.wrap(buildAwsValue())
}
object DBProxyTargetGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DBProxyTargetGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DBProxyTargetGroup =
      zio.aws.rds.model.DBProxyTargetGroup(
        dbProxyName.map(value => value),
        targetGroupName.map(value => value),
        targetGroupArn.map(value => value),
        isDefault.map(value => value),
        status.map(value => value),
        connectionPoolConfig.map(value => value.asEditable),
        createdDate.map(value => value),
        updatedDate.map(value => value)
      )
    def dbProxyName: Optional[String]
    def targetGroupName: Optional[String]
    def targetGroupArn: Optional[String]
    def isDefault: Optional[Boolean]
    def status: Optional[String]
    def connectionPoolConfig
        : Optional[zio.aws.rds.model.ConnectionPoolConfigurationInfo.ReadOnly]
    def createdDate: Optional[TStamp]
    def updatedDate: Optional[TStamp]
    def getDbProxyName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbProxyName", dbProxyName)
    def getTargetGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("targetGroupName", targetGroupName)
    def getTargetGroupArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("targetGroupArn", targetGroupArn)
    def getIsDefault: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isDefault", isDefault)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getConnectionPoolConfig: ZIO[
      Any,
      AwsError,
      zio.aws.rds.model.ConnectionPoolConfigurationInfo.ReadOnly
    ] = AwsError.unwrapOptionField("connectionPoolConfig", connectionPoolConfig)
    def getCreatedDate: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("createdDate", createdDate)
    def getUpdatedDate: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("updatedDate", updatedDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DBProxyTargetGroup
  ) extends zio.aws.rds.model.DBProxyTargetGroup.ReadOnly {
    override val dbProxyName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbProxyName())
      .map(value => value: String)
    override val targetGroupName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.targetGroupName())
      .map(value => value: String)
    override val targetGroupArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.targetGroupArn())
      .map(value => value: String)
    override val isDefault: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isDefault())
      .map(value => value: Boolean)
    override val status: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => value: String)
    override val connectionPoolConfig
        : Optional[zio.aws.rds.model.ConnectionPoolConfigurationInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectionPoolConfig())
        .map(value =>
          zio.aws.rds.model.ConnectionPoolConfigurationInfo.wrap(value)
        )
    override val createdDate: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdDate())
      .map(value => zio.aws.rds.model.primitives.TStamp(value))
    override val updatedDate: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedDate())
      .map(value => zio.aws.rds.model.primitives.TStamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DBProxyTargetGroup
  ): zio.aws.rds.model.DBProxyTargetGroup.ReadOnly = new Wrapper(impl)
}
