package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteDbInstanceAutomatedBackupRequest(
    dbiResourceId: Optional[String] = Optional.Absent,
    dbInstanceAutomatedBackupsArn: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DeleteDbInstanceAutomatedBackupRequest = {
    import DeleteDbInstanceAutomatedBackupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DeleteDbInstanceAutomatedBackupRequest
      .builder()
      .optionallyWith(dbiResourceId.map(value => value: java.lang.String))(
        _.dbiResourceId
      )
      .optionallyWith(
        dbInstanceAutomatedBackupsArn.map(value => value: java.lang.String)
      )(_.dbInstanceAutomatedBackupsArn)
      .build()
  }
  def asReadOnly
      : zio.aws.rds.model.DeleteDbInstanceAutomatedBackupRequest.ReadOnly =
    zio.aws.rds.model.DeleteDbInstanceAutomatedBackupRequest
      .wrap(buildAwsValue())
}
object DeleteDbInstanceAutomatedBackupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DeleteDbInstanceAutomatedBackupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DeleteDbInstanceAutomatedBackupRequest =
      zio.aws.rds.model.DeleteDbInstanceAutomatedBackupRequest(
        dbiResourceId.map(value => value),
        dbInstanceAutomatedBackupsArn.map(value => value)
      )
    def dbiResourceId: Optional[String]
    def dbInstanceAutomatedBackupsArn: Optional[String]
    def getDbiResourceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbiResourceId", dbiResourceId)
    def getDbInstanceAutomatedBackupsArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "dbInstanceAutomatedBackupsArn",
        dbInstanceAutomatedBackupsArn
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DeleteDbInstanceAutomatedBackupRequest
  ) extends zio.aws.rds.model.DeleteDbInstanceAutomatedBackupRequest.ReadOnly {
    override val dbiResourceId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbiResourceId())
      .map(value => value: String)
    override val dbInstanceAutomatedBackupsArn: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbInstanceAutomatedBackupsArn())
        .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DeleteDbInstanceAutomatedBackupRequest
  ): zio.aws.rds.model.DeleteDbInstanceAutomatedBackupRequest.ReadOnly =
    new Wrapper(impl)
}
