package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeCertificatesResponse(
    certificates: Optional[Iterable[zio.aws.rds.model.Certificate]] =
      Optional.Absent,
    marker: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DescribeCertificatesResponse = {
    import DescribeCertificatesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DescribeCertificatesResponse
      .builder()
      .optionallyWith(
        certificates.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.certificates)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DescribeCertificatesResponse.ReadOnly =
    zio.aws.rds.model.DescribeCertificatesResponse.wrap(buildAwsValue())
}
object DescribeCertificatesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DescribeCertificatesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DescribeCertificatesResponse =
      zio.aws.rds.model.DescribeCertificatesResponse(
        certificates.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        marker.map(value => value)
      )
    def certificates: Optional[List[zio.aws.rds.model.Certificate.ReadOnly]]
    def marker: Optional[String]
    def getCertificates
        : ZIO[Any, AwsError, List[zio.aws.rds.model.Certificate.ReadOnly]] =
      AwsError.unwrapOptionField("certificates", certificates)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DescribeCertificatesResponse
  ) extends zio.aws.rds.model.DescribeCertificatesResponse.ReadOnly {
    override val certificates
        : Optional[List[zio.aws.rds.model.Certificate.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.certificates())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.Certificate.wrap(item)
          }.toList
        )
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DescribeCertificatesResponse
  ): zio.aws.rds.model.DescribeCertificatesResponse.ReadOnly = new Wrapper(impl)
}
