package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeDBLogFilesDetails(
    logFileName: Optional[String] = Optional.Absent,
    lastWritten: Optional[Long] = Optional.Absent,
    size: Optional[Long] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DescribeDBLogFilesDetails = {
    import DescribeDBLogFilesDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DescribeDBLogFilesDetails
      .builder()
      .optionallyWith(logFileName.map(value => value: java.lang.String))(
        _.logFileName
      )
      .optionallyWith(lastWritten.map(value => value: java.lang.Long))(
        _.lastWritten
      )
      .optionallyWith(size.map(value => value: java.lang.Long))(_.size)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DescribeDBLogFilesDetails.ReadOnly =
    zio.aws.rds.model.DescribeDBLogFilesDetails.wrap(buildAwsValue())
}
object DescribeDBLogFilesDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DescribeDBLogFilesDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DescribeDBLogFilesDetails =
      zio.aws.rds.model.DescribeDBLogFilesDetails(
        logFileName.map(value => value),
        lastWritten.map(value => value),
        size.map(value => value)
      )
    def logFileName: Optional[String]
    def lastWritten: Optional[Long]
    def size: Optional[Long]
    def getLogFileName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("logFileName", logFileName)
    def getLastWritten: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("lastWritten", lastWritten)
    def getSize: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("size", size)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DescribeDBLogFilesDetails
  ) extends zio.aws.rds.model.DescribeDBLogFilesDetails.ReadOnly {
    override val logFileName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.logFileName())
      .map(value => value: String)
    override val lastWritten: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.lastWritten())
      .map(value => value: Long)
    override val size: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.size())
      .map(value => value: Long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DescribeDBLogFilesDetails
  ): zio.aws.rds.model.DescribeDBLogFilesDetails.ReadOnly = new Wrapper(impl)
}
