package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeDbClusterParameterGroupsResponse(
    marker: Optional[String] = Optional.Absent,
    dbClusterParameterGroups: Optional[
      Iterable[zio.aws.rds.model.DBClusterParameterGroup]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DescribeDbClusterParameterGroupsResponse = {
    import DescribeDbClusterParameterGroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DescribeDbClusterParameterGroupsResponse
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        dbClusterParameterGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dbClusterParameterGroups)
      .build()
  }
  def asReadOnly
      : zio.aws.rds.model.DescribeDbClusterParameterGroupsResponse.ReadOnly =
    zio.aws.rds.model.DescribeDbClusterParameterGroupsResponse
      .wrap(buildAwsValue())
}
object DescribeDbClusterParameterGroupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DescribeDbClusterParameterGroupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DescribeDbClusterParameterGroupsResponse =
      zio.aws.rds.model.DescribeDbClusterParameterGroupsResponse(
        marker.map(value => value),
        dbClusterParameterGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def marker: Optional[String]
    def dbClusterParameterGroups
        : Optional[List[zio.aws.rds.model.DBClusterParameterGroup.ReadOnly]]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getDbClusterParameterGroups: ZIO[Any, AwsError, List[
      zio.aws.rds.model.DBClusterParameterGroup.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "dbClusterParameterGroups",
      dbClusterParameterGroups
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DescribeDbClusterParameterGroupsResponse
  ) extends zio.aws.rds.model.DescribeDbClusterParameterGroupsResponse.ReadOnly {
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
    override val dbClusterParameterGroups
        : Optional[List[zio.aws.rds.model.DBClusterParameterGroup.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbClusterParameterGroups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.DBClusterParameterGroup.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DescribeDbClusterParameterGroupsResponse
  ): zio.aws.rds.model.DescribeDbClusterParameterGroupsResponse.ReadOnly =
    new Wrapper(impl)
}
