package zio.aws.rds.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.rds.model.primitives.IntegerOptional
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeDbClusterSnapshotsRequest(
    dbClusterIdentifier: Optional[String] = Optional.Absent,
    dbClusterSnapshotIdentifier: Optional[String] = Optional.Absent,
    snapshotType: Optional[String] = Optional.Absent,
    filters: Optional[Iterable[zio.aws.rds.model.Filter]] = Optional.Absent,
    maxRecords: Optional[IntegerOptional] = Optional.Absent,
    marker: Optional[String] = Optional.Absent,
    includeShared: Optional[Boolean] = Optional.Absent,
    includePublic: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DescribeDbClusterSnapshotsRequest = {
    import DescribeDbClusterSnapshotsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DescribeDbClusterSnapshotsRequest
      .builder()
      .optionallyWith(
        dbClusterIdentifier.map(value => value: java.lang.String)
      )(_.dbClusterIdentifier)
      .optionallyWith(
        dbClusterSnapshotIdentifier.map(value => value: java.lang.String)
      )(_.dbClusterSnapshotIdentifier)
      .optionallyWith(snapshotType.map(value => value: java.lang.String))(
        _.snapshotType
      )
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(maxRecords.map(value => value: Integer))(_.maxRecords)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(includeShared.map(value => value: java.lang.Boolean))(
        _.includeShared
      )
      .optionallyWith(includePublic.map(value => value: java.lang.Boolean))(
        _.includePublic
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DescribeDbClusterSnapshotsRequest.ReadOnly =
    zio.aws.rds.model.DescribeDbClusterSnapshotsRequest.wrap(buildAwsValue())
}
object DescribeDbClusterSnapshotsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DescribeDbClusterSnapshotsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DescribeDbClusterSnapshotsRequest =
      zio.aws.rds.model.DescribeDbClusterSnapshotsRequest(
        dbClusterIdentifier.map(value => value),
        dbClusterSnapshotIdentifier.map(value => value),
        snapshotType.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxRecords.map(value => value),
        marker.map(value => value),
        includeShared.map(value => value),
        includePublic.map(value => value)
      )
    def dbClusterIdentifier: Optional[String]
    def dbClusterSnapshotIdentifier: Optional[String]
    def snapshotType: Optional[String]
    def filters: Optional[List[zio.aws.rds.model.Filter.ReadOnly]]
    def maxRecords: Optional[IntegerOptional]
    def marker: Optional[String]
    def includeShared: Optional[Boolean]
    def includePublic: Optional[Boolean]
    def getDbClusterIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbClusterIdentifier", dbClusterIdentifier)
    def getDbClusterSnapshotIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "dbClusterSnapshotIdentifier",
        dbClusterSnapshotIdentifier
      )
    def getSnapshotType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotType", snapshotType)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.rds.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getIncludeShared: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("includeShared", includeShared)
    def getIncludePublic: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("includePublic", includePublic)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DescribeDbClusterSnapshotsRequest
  ) extends zio.aws.rds.model.DescribeDbClusterSnapshotsRequest.ReadOnly {
    override val dbClusterIdentifier: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbClusterIdentifier())
      .map(value => value: String)
    override val dbClusterSnapshotIdentifier: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbClusterSnapshotIdentifier())
        .map(value => value: String)
    override val snapshotType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.snapshotType())
      .map(value => value: String)
    override val filters: Optional[List[zio.aws.rds.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.Filter.wrap(item)
          }.toList
        )
    override val maxRecords: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.maxRecords())
      .map(value => value: IntegerOptional)
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
    override val includeShared: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.includeShared())
      .map(value => value: Boolean)
    override val includePublic: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.includePublic())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DescribeDbClusterSnapshotsRequest
  ): zio.aws.rds.model.DescribeDbClusterSnapshotsRequest.ReadOnly = new Wrapper(
    impl
  )
}
