package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeDbEngineVersionsResponse(
    marker: Optional[String] = Optional.Absent,
    dbEngineVersions: Optional[Iterable[zio.aws.rds.model.DBEngineVersion]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DescribeDbEngineVersionsResponse = {
    import DescribeDbEngineVersionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DescribeDbEngineVersionsResponse
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        dbEngineVersions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dbEngineVersions)
      .build()
  }
  def asReadOnly: zio.aws.rds.model.DescribeDbEngineVersionsResponse.ReadOnly =
    zio.aws.rds.model.DescribeDbEngineVersionsResponse.wrap(buildAwsValue())
}
object DescribeDbEngineVersionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DescribeDbEngineVersionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DescribeDbEngineVersionsResponse =
      zio.aws.rds.model.DescribeDbEngineVersionsResponse(
        marker.map(value => value),
        dbEngineVersions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def marker: Optional[String]
    def dbEngineVersions
        : Optional[List[zio.aws.rds.model.DBEngineVersion.ReadOnly]]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getDbEngineVersions
        : ZIO[Any, AwsError, List[zio.aws.rds.model.DBEngineVersion.ReadOnly]] =
      AwsError.unwrapOptionField("dbEngineVersions", dbEngineVersions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DescribeDbEngineVersionsResponse
  ) extends zio.aws.rds.model.DescribeDbEngineVersionsResponse.ReadOnly {
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
    override val dbEngineVersions
        : Optional[List[zio.aws.rds.model.DBEngineVersion.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbEngineVersions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.DBEngineVersion.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DescribeDbEngineVersionsResponse
  ): zio.aws.rds.model.DescribeDbEngineVersionsResponse.ReadOnly = new Wrapper(
    impl
  )
}
