package zio.aws.rds.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.rds.model.primitives.{IntegerOptional, BooleanOptional}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeReservedDbInstancesRequest(
    reservedDBInstanceId: Optional[String] = Optional.Absent,
    reservedDBInstancesOfferingId: Optional[String] = Optional.Absent,
    dbInstanceClass: Optional[String] = Optional.Absent,
    duration: Optional[String] = Optional.Absent,
    productDescription: Optional[String] = Optional.Absent,
    offeringType: Optional[String] = Optional.Absent,
    multiAZ: Optional[BooleanOptional] = Optional.Absent,
    leaseId: Optional[String] = Optional.Absent,
    filters: Optional[Iterable[zio.aws.rds.model.Filter]] = Optional.Absent,
    maxRecords: Optional[IntegerOptional] = Optional.Absent,
    marker: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesRequest = {
    import DescribeReservedDbInstancesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesRequest
      .builder()
      .optionallyWith(
        reservedDBInstanceId.map(value => value: java.lang.String)
      )(_.reservedDBInstanceId)
      .optionallyWith(
        reservedDBInstancesOfferingId.map(value => value: java.lang.String)
      )(_.reservedDBInstancesOfferingId)
      .optionallyWith(dbInstanceClass.map(value => value: java.lang.String))(
        _.dbInstanceClass
      )
      .optionallyWith(duration.map(value => value: java.lang.String))(
        _.duration
      )
      .optionallyWith(productDescription.map(value => value: java.lang.String))(
        _.productDescription
      )
      .optionallyWith(offeringType.map(value => value: java.lang.String))(
        _.offeringType
      )
      .optionallyWith(multiAZ.map(value => value: java.lang.Boolean))(_.multiAZ)
      .optionallyWith(leaseId.map(value => value: java.lang.String))(_.leaseId)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(maxRecords.map(value => value: Integer))(_.maxRecords)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.rds.model.DescribeReservedDbInstancesRequest.ReadOnly =
    zio.aws.rds.model.DescribeReservedDbInstancesRequest.wrap(buildAwsValue())
}
object DescribeReservedDbInstancesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.DescribeReservedDbInstancesRequest =
      zio.aws.rds.model.DescribeReservedDbInstancesRequest(
        reservedDBInstanceId.map(value => value),
        reservedDBInstancesOfferingId.map(value => value),
        dbInstanceClass.map(value => value),
        duration.map(value => value),
        productDescription.map(value => value),
        offeringType.map(value => value),
        multiAZ.map(value => value),
        leaseId.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxRecords.map(value => value),
        marker.map(value => value)
      )
    def reservedDBInstanceId: Optional[String]
    def reservedDBInstancesOfferingId: Optional[String]
    def dbInstanceClass: Optional[String]
    def duration: Optional[String]
    def productDescription: Optional[String]
    def offeringType: Optional[String]
    def multiAZ: Optional[BooleanOptional]
    def leaseId: Optional[String]
    def filters: Optional[List[zio.aws.rds.model.Filter.ReadOnly]]
    def maxRecords: Optional[IntegerOptional]
    def marker: Optional[String]
    def getReservedDBInstanceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("reservedDBInstanceId", reservedDBInstanceId)
    def getReservedDBInstancesOfferingId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "reservedDBInstancesOfferingId",
        reservedDBInstancesOfferingId
      )
    def getDbInstanceClass: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbInstanceClass", dbInstanceClass)
    def getDuration: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("duration", duration)
    def getProductDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("productDescription", productDescription)
    def getOfferingType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("offeringType", offeringType)
    def getMultiAZ: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("multiAZ", multiAZ)
    def getLeaseId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("leaseId", leaseId)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.rds.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesRequest
  ) extends zio.aws.rds.model.DescribeReservedDbInstancesRequest.ReadOnly {
    override val reservedDBInstanceId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.reservedDBInstanceId())
      .map(value => value: String)
    override val reservedDBInstancesOfferingId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reservedDBInstancesOfferingId())
        .map(value => value: String)
    override val dbInstanceClass: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbInstanceClass())
      .map(value => value: String)
    override val duration: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.duration())
      .map(value => value: String)
    override val productDescription: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.productDescription())
      .map(value => value: String)
    override val offeringType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.offeringType())
      .map(value => value: String)
    override val multiAZ: Optional[BooleanOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.multiAZ())
      .map(value => value: BooleanOptional)
    override val leaseId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.leaseId())
      .map(value => value: String)
    override val filters: Optional[List[zio.aws.rds.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rds.model.Filter.wrap(item)
          }.toList
        )
    override val maxRecords: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.maxRecords())
      .map(value => value: IntegerOptional)
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesRequest
  ): zio.aws.rds.model.DescribeReservedDbInstancesRequest.ReadOnly =
    new Wrapper(impl)
}
