package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeValidDbInstanceModificationsResponse(
    validDBInstanceModificationsMessage: Optional[
      zio.aws.rds.model.ValidDBInstanceModificationsMessage
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.DescribeValidDbInstanceModificationsResponse = {
    import DescribeValidDbInstanceModificationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.DescribeValidDbInstanceModificationsResponse
      .builder()
      .optionallyWith(
        validDBInstanceModificationsMessage.map(value => value.buildAwsValue())
      )(_.validDBInstanceModificationsMessage)
      .build()
  }
  def asReadOnly
      : zio.aws.rds.model.DescribeValidDbInstanceModificationsResponse.ReadOnly =
    zio.aws.rds.model.DescribeValidDbInstanceModificationsResponse
      .wrap(buildAwsValue())
}
object DescribeValidDbInstanceModificationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rds.model.DescribeValidDbInstanceModificationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.rds.model.DescribeValidDbInstanceModificationsResponse =
      zio.aws.rds.model.DescribeValidDbInstanceModificationsResponse(
        validDBInstanceModificationsMessage.map(value => value.asEditable)
      )
    def validDBInstanceModificationsMessage: Optional[
      zio.aws.rds.model.ValidDBInstanceModificationsMessage.ReadOnly
    ]
    def getValidDBInstanceModificationsMessage: ZIO[
      Any,
      AwsError,
      zio.aws.rds.model.ValidDBInstanceModificationsMessage.ReadOnly
    ] = AwsError.unwrapOptionField(
      "validDBInstanceModificationsMessage",
      validDBInstanceModificationsMessage
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.DescribeValidDbInstanceModificationsResponse
  ) extends zio.aws.rds.model.DescribeValidDbInstanceModificationsResponse.ReadOnly {
    override val validDBInstanceModificationsMessage: Optional[
      zio.aws.rds.model.ValidDBInstanceModificationsMessage.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.validDBInstanceModificationsMessage())
      .map(value =>
        zio.aws.rds.model.ValidDBInstanceModificationsMessage.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.DescribeValidDbInstanceModificationsResponse
  ): zio.aws.rds.model.DescribeValidDbInstanceModificationsResponse.ReadOnly =
    new Wrapper(impl)
}
