package zio.aws.rds.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class FailoverState(
    status: Optional[zio.aws.rds.model.FailoverStatus] = Optional.Absent,
    fromDbClusterArn: Optional[String] = Optional.Absent,
    toDbClusterArn: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rds.model.FailoverState = {
    import FailoverState.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rds.model.FailoverState
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(fromDbClusterArn.map(value => value: java.lang.String))(
        _.fromDbClusterArn
      )
      .optionallyWith(toDbClusterArn.map(value => value: java.lang.String))(
        _.toDbClusterArn
      )
      .build()
  }
  def asReadOnly: zio.aws.rds.model.FailoverState.ReadOnly =
    zio.aws.rds.model.FailoverState.wrap(buildAwsValue())
}
object FailoverState {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.rds.model.FailoverState] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rds.model.FailoverState =
      zio.aws.rds.model.FailoverState(
        status.map(value => value),
        fromDbClusterArn.map(value => value),
        toDbClusterArn.map(value => value)
      )
    def status: Optional[zio.aws.rds.model.FailoverStatus]
    def fromDbClusterArn: Optional[String]
    def toDbClusterArn: Optional[String]
    def getStatus: ZIO[Any, AwsError, zio.aws.rds.model.FailoverStatus] =
      AwsError.unwrapOptionField("status", status)
    def getFromDbClusterArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("fromDbClusterArn", fromDbClusterArn)
    def getToDbClusterArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("toDbClusterArn", toDbClusterArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rds.model.FailoverState
  ) extends zio.aws.rds.model.FailoverState.ReadOnly {
    override val status: Optional[zio.aws.rds.model.FailoverStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.rds.model.FailoverStatus.wrap(value))
    override val fromDbClusterArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.fromDbClusterArn())
      .map(value => value: String)
    override val toDbClusterArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.toDbClusterArn())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rds.model.FailoverState
  ): zio.aws.rds.model.FailoverState.ReadOnly = new Wrapper(impl)
}
